/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScanOptions {
    public static ScanOptions NONE = new ScanOptions(null, null, null);
    private final @Nullable Long count;
    private final @Nullable String pattern;
    private final byte @Nullable [] bytePattern;

    ScanOptions(@Nullable Long count, @Nullable String pattern, byte @Nullable [] bytePattern) {
        this.count = count;
        this.pattern = pattern;
        this.bytePattern = bytePattern;
    }

    public static ScanOptionsBuilder scanOptions() {
        return new ScanOptionsBuilder();
    }

    public @Nullable Long getCount() {
        return this.count;
    }

    public @Nullable String getPattern() {
        if (this.bytePattern != null && this.pattern == null) {
            return new String(this.bytePattern);
        }
        return this.pattern;
    }

    public byte @Nullable [] getBytePattern() {
        if (this.bytePattern == null && this.pattern != null) {
            return this.pattern.getBytes();
        }
        return this.bytePattern;
    }

    public String toOptionString() {
        String pattern;
        if (this.equals(NONE)) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ");
        if (this.getCount() != null) {
            joiner.add("'count' " + this.getCount());
        }
        if (StringUtils.hasText((String)(pattern = this.getPattern()))) {
            joiner.add("'match' '" + pattern + "'");
        }
        return joiner.toString();
    }

    public static class ScanOptionsBuilder {
        @Nullable Long count;
        @Nullable String pattern;
        byte @Nullable [] bytePattern;
        @Nullable DataType type;

        ScanOptionsBuilder() {
        }

        public ScanOptionsBuilder count(long count) {
            this.count = count;
            return this;
        }

        public ScanOptionsBuilder match(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public ScanOptionsBuilder match(byte[] pattern) {
            this.bytePattern = pattern;
            return this;
        }

        public ScanOptionsBuilder type(DataType type) {
            Assert.notNull((Object)((Object)type), (String)"Type must not be null Use NONE instead");
            this.type = type;
            return this;
        }

        public ScanOptionsBuilder type(String type) {
            Assert.notNull((Object)type, (String)"Type must not be null");
            return this.type(DataType.fromCode(type));
        }

        public ScanOptions build() {
            if (this.type != null && !DataType.NONE.equals((Object)this.type)) {
                return new KeyScanOptions(this.count, this.pattern, this.bytePattern, this.type.code());
            }
            return new ScanOptions(this.count, this.pattern, this.bytePattern);
        }
    }
}

