/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.support.collections.AbstractRedisCollection;
import org.springframework.data.redis.support.collections.CollectionUtils;
import org.springframework.data.redis.support.collections.RedisIterator;
import org.springframework.data.redis.support.collections.RedisSet;

public class DefaultRedisSet<E>
extends AbstractRedisCollection<E>
implements RedisSet<E> {
    private final BoundSetOperations<String, E> boundSetOps;

    public DefaultRedisSet(String key, RedisOperations<String, E> operations) {
        super(key, operations);
        this.boundSetOps = operations.boundSetOps(key);
    }

    public DefaultRedisSet(BoundSetOperations<String, E> boundOps) {
        super((String)boundOps.getKey(), boundOps.getOperations());
        this.boundSetOps = boundOps;
    }

    @Override
    public Set<E> diff(RedisSet<?> set) {
        return this.boundSetOps.difference((String)set.getKey());
    }

    @Override
    public Set<E> diff(Collection<? extends RedisSet<?>> sets) {
        return this.boundSetOps.difference(CollectionUtils.extractKeys(sets));
    }

    @Override
    public RedisSet<E> diffAndStore(RedisSet<?> set, String destKey) {
        this.boundSetOps.differenceAndStore((String)set.getKey(), destKey);
        return new DefaultRedisSet<E>(this.boundSetOps.getOperations().boundSetOps(destKey));
    }

    @Override
    public RedisSet<E> diffAndStore(Collection<? extends RedisSet<?>> sets, String destKey) {
        this.boundSetOps.differenceAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisSet<E>(this.boundSetOps.getOperations().boundSetOps(destKey));
    }

    @Override
    public Set<E> intersect(RedisSet<?> set) {
        return this.boundSetOps.intersect((String)set.getKey());
    }

    @Override
    public Set<E> intersect(Collection<? extends RedisSet<?>> sets) {
        return this.boundSetOps.intersect(CollectionUtils.extractKeys(sets));
    }

    @Override
    public RedisSet<E> intersectAndStore(RedisSet<?> set, String destKey) {
        this.boundSetOps.intersectAndStore((String)set.getKey(), destKey);
        return new DefaultRedisSet<E>(this.boundSetOps.getOperations().boundSetOps(destKey));
    }

    @Override
    public RedisSet<E> intersectAndStore(Collection<? extends RedisSet<?>> sets, String destKey) {
        this.boundSetOps.intersectAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisSet<E>(this.boundSetOps.getOperations().boundSetOps(destKey));
    }

    @Override
    public Long intersectSize(RedisSet<?> set) {
        return this.boundSetOps.intersectSize((String)set.getKey());
    }

    @Override
    public Long intersectSize(Collection<? extends RedisSet<?>> sets) {
        return this.boundSetOps.intersectSize(CollectionUtils.extractKeys(sets));
    }

    @Override
    public Set<E> union(RedisSet<?> set) {
        return this.boundSetOps.union((String)set.getKey());
    }

    @Override
    public Set<E> union(Collection<? extends RedisSet<?>> sets) {
        return this.boundSetOps.union(CollectionUtils.extractKeys(sets));
    }

    @Override
    public RedisSet<E> unionAndStore(RedisSet<?> set, String destKey) {
        this.boundSetOps.unionAndStore((String)set.getKey(), destKey);
        return new DefaultRedisSet<E>(this.boundSetOps.getOperations().boundSetOps(destKey));
    }

    @Override
    public RedisSet<E> unionAndStore(Collection<? extends RedisSet<?>> sets, String destKey) {
        this.boundSetOps.unionAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisSet<E>(this.boundSetOps.getOperations().boundSetOps(destKey));
    }

    @Override
    public E randomValue() {
        return this.boundSetOps.randomMember();
    }

    @Override
    public boolean add(E e) {
        Long result = this.boundSetOps.add(e);
        this.checkResult(result);
        return result == 1L;
    }

    @Override
    public void clear() {
        this.boundSetOps.getOperations().delete(this.getKey());
    }

    @Override
    public boolean contains(Object o) {
        Boolean result = this.boundSetOps.isMember(o);
        this.checkResult(result);
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        Map<Object, Boolean> member = this.boundSetOps.isMember(c.toArray());
        this.checkResult(member);
        return member.values().stream().reduce(true, (left, right) -> left != false && right != false);
    }

    @Override
    public Iterator<E> iterator() {
        Set<E> members = this.boundSetOps.members();
        this.checkResult(members);
        return new DefaultRedisSetIterator(members.iterator());
    }

    @Override
    public boolean remove(Object o) {
        Long result = this.boundSetOps.remove(o);
        this.checkResult(result);
        return result == 1L;
    }

    @Override
    public int size() {
        Long result = this.boundSetOps.size();
        this.checkResult(result);
        return result.intValue();
    }

    @Override
    public DataType getType() {
        return DataType.SET;
    }

    @Override
    public Cursor<E> scan() {
        return this.scan(ScanOptions.NONE);
    }

    public Cursor<E> scan(ScanOptions options) {
        return this.boundSetOps.scan(options);
    }

    private class DefaultRedisSetIterator
    extends RedisIterator<E> {
        public DefaultRedisSetIterator(Iterator<E> delegate) {
            super(delegate);
        }

        @Override
        protected void removeFromRedisStorage(E item) {
            DefaultRedisSet.this.remove(item);
        }
    }
}

