/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.restdocs.mockmvc.IterableEnumeration;
import org.springframework.restdocs.operation.ConversionException;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

class MockMvcRequestConverter
implements RequestConverter<MockHttpServletRequest> {
    MockMvcRequestConverter() {
    }

    public OperationRequest convert(MockHttpServletRequest mockRequest) {
        try {
            HttpHeaders headers = this.extractHeaders(mockRequest);
            List<OperationRequestPart> parts = this.extractParts(mockRequest);
            Collection<RequestCookie> cookies = this.extractCookies(mockRequest, headers);
            String requestMethod = mockRequest.getMethod();
            if (requestMethod == null) {
                throw new IllegalStateException("MockHttpServletRequest cannot be converted as its method is null");
            }
            return new OperationRequestFactory().create(this.getRequestUri(mockRequest), HttpMethod.valueOf((String)requestMethod), this.getRequestContent(mockRequest, headers), headers, parts, cookies);
        }
        catch (Exception ex) {
            throw new ConversionException((Throwable)ex);
        }
    }

    private URI getRequestUri(MockHttpServletRequest mockRequest) {
        String queryString = "";
        if (mockRequest.getQueryString() != null) {
            queryString = mockRequest.getQueryString();
        } else if ("GET".equals(mockRequest.getMethod()) || mockRequest.getContentLengthLong() > 0L) {
            queryString = this.urlEncodedParameters(mockRequest);
        }
        StringBuffer requestUrlBuffer = mockRequest.getRequestURL();
        if (queryString.length() > 0) {
            requestUrlBuffer.append("?").append(queryString.toString());
        }
        return URI.create(requestUrlBuffer.toString());
    }

    private String urlEncodedParameters(MockHttpServletRequest mockRequest) {
        StringBuilder parameters = new StringBuilder();
        MultiValueMap<String, String> queryParameters = MockMvcRequestConverter.parse(mockRequest.getQueryString());
        for (String name : IterableEnumeration.of(mockRequest.getParameterNames())) {
            if (queryParameters.containsKey((Object)name)) continue;
            String[] values = mockRequest.getParameterValues(name);
            if (values == null || values.length == 0) {
                MockMvcRequestConverter.append(parameters, name);
                continue;
            }
            for (String value : values) {
                MockMvcRequestConverter.append(parameters, name, value);
            }
        }
        return parameters.toString();
    }

    private byte @Nullable [] getRequestContent(MockHttpServletRequest mockRequest, HttpHeaders headers) {
        Map parameters;
        byte[] content = mockRequest.getContentAsByteArray();
        if ("GET".equals(mockRequest.getMethod())) {
            return content;
        }
        MediaType contentType = headers.getContentType();
        if (!(contentType != null && !MediaType.APPLICATION_FORM_URLENCODED.includes(contentType) || (parameters = mockRequest.getParameterMap()).isEmpty() || content != null && content.length != 0)) {
            StringBuilder contentBuilder = new StringBuilder();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            MultiValueMap<String, String> queryParameters = MockMvcRequestConverter.parse(mockRequest.getQueryString());
            mockRequest.getParameterMap().forEach((name, values) -> {
                List queryParameterValues = (List)queryParameters.get(name);
                if (((String[])values).length == 0) {
                    if (queryParameterValues == null) {
                        MockMvcRequestConverter.append(contentBuilder, name);
                    }
                } else {
                    for (String value : values) {
                        if (queryParameterValues != null && queryParameterValues.contains(value)) continue;
                        MockMvcRequestConverter.append(contentBuilder, name, value);
                    }
                }
            });
            return contentBuilder.toString().getBytes(StandardCharsets.UTF_8);
        }
        return content;
    }

    private Collection<RequestCookie> extractCookies(MockHttpServletRequest mockRequest, HttpHeaders headers) {
        if (mockRequest.getCookies() == null || mockRequest.getCookies().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<RequestCookie> cookies = new ArrayList<RequestCookie>();
        for (Cookie servletCookie : mockRequest.getCookies()) {
            cookies.add(new RequestCookie(servletCookie.getName(), servletCookie.getValue()));
        }
        headers.remove("Cookie");
        return cookies;
    }

    private List<OperationRequestPart> extractParts(MockHttpServletRequest servletRequest) throws IOException, ServletException {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        parts.addAll(this.extractServletRequestParts(servletRequest));
        if (servletRequest instanceof MockMultipartHttpServletRequest) {
            parts.addAll(this.extractMultipartRequestParts((MockMultipartHttpServletRequest)servletRequest));
        }
        return parts;
    }

    private List<OperationRequestPart> extractServletRequestParts(MockHttpServletRequest servletRequest) throws IOException, ServletException {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        for (Part part : servletRequest.getParts()) {
            parts.add(this.createOperationRequestPart(part));
        }
        return parts;
    }

    private OperationRequestPart createOperationRequestPart(Part part) throws IOException {
        HttpHeaders partHeaders = this.extractHeaders(part);
        List contentTypeHeader = partHeaders.get("Content-Type");
        if (part.getContentType() != null && contentTypeHeader == null) {
            partHeaders.setContentType(MediaType.parseMediaType((String)part.getContentType()));
        }
        return new OperationRequestPartFactory().create(part.getName(), StringUtils.hasText((String)part.getSubmittedFileName()) ? part.getSubmittedFileName() : null, FileCopyUtils.copyToByteArray((InputStream)part.getInputStream()), partHeaders);
    }

    private List<OperationRequestPart> extractMultipartRequestParts(MockMultipartHttpServletRequest multipartRequest) throws IOException {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        for (Map.Entry entry : multipartRequest.getMultiFileMap().entrySet()) {
            for (MultipartFile file : (List)entry.getValue()) {
                parts.add(this.createOperationRequestPart(file));
            }
        }
        return parts;
    }

    private OperationRequestPart createOperationRequestPart(MultipartFile file) throws IOException {
        HttpHeaders partHeaders = new HttpHeaders();
        if (StringUtils.hasText((String)file.getContentType())) {
            partHeaders.setContentType(MediaType.parseMediaType((String)file.getContentType()));
        }
        return new OperationRequestPartFactory().create(file.getName(), StringUtils.hasText((String)file.getOriginalFilename()) ? file.getOriginalFilename() : null, file.getBytes(), partHeaders);
    }

    private HttpHeaders extractHeaders(Part part) {
        HttpHeaders partHeaders = new HttpHeaders();
        for (String headerName : part.getHeaderNames()) {
            for (String value : part.getHeaders(headerName)) {
                partHeaders.add(headerName, value);
            }
        }
        return partHeaders;
    }

    private HttpHeaders extractHeaders(MockHttpServletRequest servletRequest) {
        HttpHeaders headers = new HttpHeaders();
        for (String headerName : IterableEnumeration.of(servletRequest.getHeaderNames())) {
            for (String value : IterableEnumeration.of(servletRequest.getHeaders(headerName))) {
                headers.add(headerName, value);
            }
        }
        return headers;
    }

    private static void append(StringBuilder sb, String key) {
        MockMvcRequestConverter.append(sb, key, "");
    }

    private static void append(StringBuilder sb, String key, String value) {
        MockMvcRequestConverter.doAppend(sb, MockMvcRequestConverter.urlEncode(key) + "=" + MockMvcRequestConverter.urlEncode(value));
    }

    private static void doAppend(StringBuilder sb, String toAppend) {
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(toAppend);
    }

    private static String urlEncode(String s) {
        if (!StringUtils.hasLength((String)s)) {
            return "";
        }
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private static MultiValueMap<String, String> parse(@Nullable String query) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (!StringUtils.hasLength((String)query)) {
            return parameters;
        }
        try (Scanner scanner = new Scanner(query);){
            scanner.useDelimiter("&");
            while (scanner.hasNext()) {
                MockMvcRequestConverter.processParameter(scanner.next(), (MultiValueMap<String, String>)parameters);
            }
        }
        return parameters;
    }

    private static void processParameter(String parameter, MultiValueMap<String, String> parameters) {
        String[] components = parameter.split("=");
        if (components.length > 0 && components.length < 3) {
            if (components.length == 2) {
                String name = components[0];
                String value = components[1];
                parameters.add((Object)MockMvcRequestConverter.decode(name), (Object)MockMvcRequestConverter.decode(value));
            } else {
                List values = (List)parameters.computeIfAbsent((Object)components[0], p -> new LinkedList());
                values.add("");
            }
        } else {
            throw new IllegalArgumentException("The parameter '" + parameter + "' is malformed");
        }
    }

    private static String decode(String encoded) {
        return URLDecoder.decode(encoded, StandardCharsets.US_ASCII);
    }
}

