/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.util.Assert;

public class RemoveAuthorizedClientOAuth2AuthorizationFailureHandler
implements OAuth2AuthorizationFailureHandler {
    public static final Set<String> DEFAULT_REMOVE_AUTHORIZED_CLIENT_ERROR_CODES;
    private final Set<String> removeAuthorizedClientErrorCodes;
    private final OAuth2AuthorizedClientRemover delegate;

    public RemoveAuthorizedClientOAuth2AuthorizationFailureHandler(OAuth2AuthorizedClientRemover authorizedClientRemover) {
        this(authorizedClientRemover, DEFAULT_REMOVE_AUTHORIZED_CLIENT_ERROR_CODES);
    }

    public RemoveAuthorizedClientOAuth2AuthorizationFailureHandler(OAuth2AuthorizedClientRemover authorizedClientRemover, Set<String> removeAuthorizedClientErrorCodes) {
        Assert.notNull((Object)authorizedClientRemover, (String)"authorizedClientRemover cannot be null");
        Assert.notNull(removeAuthorizedClientErrorCodes, (String)"removeAuthorizedClientErrorCodes cannot be null");
        this.removeAuthorizedClientErrorCodes = Collections.unmodifiableSet(new HashSet<String>(removeAuthorizedClientErrorCodes));
        this.delegate = authorizedClientRemover;
    }

    @Override
    public void onAuthorizationFailure(OAuth2AuthorizationException authorizationException, Authentication principal, Map<String, Object> attributes) {
        if (authorizationException instanceof ClientAuthorizationException) {
            ClientAuthorizationException clientAuthorizationException = (ClientAuthorizationException)authorizationException;
            if (this.hasRemovalErrorCode(authorizationException)) {
                this.delegate.removeAuthorizedClient(clientAuthorizationException.getClientRegistrationId(), principal, attributes);
            }
        }
    }

    private boolean hasRemovalErrorCode(OAuth2AuthorizationException authorizationException) {
        return this.removeAuthorizedClientErrorCodes.contains(authorizationException.getError().getErrorCode());
    }

    static {
        LinkedHashSet<String> codes = new LinkedHashSet<String>();
        codes.add("invalid_token");
        codes.add("invalid_grant");
        DEFAULT_REMOVE_AUTHORIZED_CLIENT_ERROR_CODES = Collections.unmodifiableSet(codes);
    }

    @FunctionalInterface
    public static interface OAuth2AuthorizedClientRemover {
        public void removeAuthorizedClient(String var1, Authentication var2, Map<String, Object> var3);
    }
}

