/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.time.Instant;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class OpaqueTokenReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private ReactiveOpaqueTokenIntrospector introspector;

    public OpaqueTokenReactiveAuthenticationManager(ReactiveOpaqueTokenIntrospector introspector) {
        Assert.notNull((Object)introspector, (String)"introspector cannot be null");
        this.introspector = introspector;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.justOrEmpty((Object)authentication).filter(BearerTokenAuthenticationToken.class::isInstance).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(this::authenticate).cast(Authentication.class);
    }

    private Mono<BearerTokenAuthentication> authenticate(String token) {
        return this.introspector.introspect(token).map(principal -> {
            Instant iat = (Instant)principal.getAttribute("iat");
            Instant exp = (Instant)principal.getAttribute("exp");
            OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, token, iat, exp);
            return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)principal, accessToken, principal.getAuthorities());
        }).onErrorMap(OAuth2IntrospectionException.class, this::onError);
    }

    private AuthenticationException onError(OAuth2IntrospectionException e) {
        if (e instanceof BadOpaqueTokenException) {
            return new InvalidBearerTokenException(e.getMessage(), e);
        }
        return new AuthenticationServiceException(e.getMessage(), (Throwable)e);
    }
}

