/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.expression.TargetedAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

abstract class AstUtils {
    AstUtils() {
    }

    static <T extends TargetedAccessor> List<T> getAccessorsToTry(@Nullable Object targetObject, List<T> accessors) {
        Class<?> targetType = targetObject != null ? targetObject.getClass() : null;
        return AstUtils.getAccessorsToTry(targetType, accessors);
    }

    static <T extends TargetedAccessor> List<T> getAccessorsToTry(@Nullable Class<?> targetType, List<T> accessors) {
        if (accessors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TargetedAccessor> exactMatches = new ArrayList<TargetedAccessor>();
        ArrayList<TargetedAccessor> inexactMatches = new ArrayList<TargetedAccessor>();
        ArrayList<TargetedAccessor> genericMatches = new ArrayList<TargetedAccessor>();
        for (TargetedAccessor accessor : accessors) {
            Object[] targets = accessor.getSpecificTargetClasses();
            if (ObjectUtils.isEmpty((Object[])targets)) {
                genericMatches.add(accessor);
                continue;
            }
            if (targetType == null) continue;
            for (Object clazz : targets) {
                if (clazz == targetType) {
                    exactMatches.add(accessor);
                    continue;
                }
                if (!((Class)clazz).isAssignableFrom(targetType)) continue;
                inexactMatches.add(accessor);
            }
        }
        int size = exactMatches.size() + inexactMatches.size() + genericMatches.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<TargetedAccessor> result = new ArrayList<TargetedAccessor>(size);
        result.addAll(exactMatches);
        result.addAll(inexactMatches);
        result.addAll(genericMatches);
        return result;
    }
}

