/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jdo.DefaultJdoDialect;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class LocalPersistenceManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    private static final Method getPersistenceManagerFactoryMethod = ClassUtils.getMethodIfAvailable((Class)(class$javax$jdo$JDOHelper == null ? (class$javax$jdo$JDOHelper = LocalPersistenceManagerFactoryBean.class$("javax.jdo.JDOHelper")) : class$javax$jdo$JDOHelper), (String)"getPersistenceManagerFactory", (Class[])new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = LocalPersistenceManagerFactoryBean.class$("java.util.Properties")) : class$java$util$Properties});
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Properties jdoProperties;
    private PersistenceManagerFactory persistenceManagerFactory;
    private JdoDialect jdoDialect;
    static /* synthetic */ Class class$javax$jdo$JDOHelper;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setJdoProperties(Properties jdoProperties) {
        this.jdoProperties = jdoProperties;
    }

    public Properties getJdoProperties() {
        if (this.jdoProperties == null) {
            this.jdoProperties = new Properties();
        }
        return this.jdoProperties;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, IOException, JDOException {
        if (this.configLocation == null && this.jdoProperties == null) {
            throw new IllegalArgumentException("Either configLocation or jdoProperties must be set");
        }
        Properties mergedProps = new Properties();
        if (this.configLocation != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loading JDO config from [" + this.configLocation + "]"));
            }
            PropertiesLoaderUtils.fillProperties((Properties)mergedProps, (Resource)this.configLocation);
        }
        CollectionUtils.mergePropertiesIntoMap((Properties)this.jdoProperties, (Map)mergedProps);
        this.logger.info((Object)"Building new JDO PersistenceManagerFactory");
        this.persistenceManagerFactory = this.newPersistenceManagerFactory(mergedProps);
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect(this.persistenceManagerFactory.getConnectionFactory());
        }
    }

    protected PersistenceManagerFactory newPersistenceManagerFactory(Properties props) {
        if (getPersistenceManagerFactoryMethod != null) {
            return (PersistenceManagerFactory)ReflectionUtils.invokeMethod((Method)getPersistenceManagerFactoryMethod, null, (Object[])new Object[]{props});
        }
        return JDOHelper.getPersistenceManagerFactory((Map)props);
    }

    public Object getObject() {
        return this.persistenceManagerFactory;
    }

    public Class getObjectType() {
        return this.persistenceManagerFactory != null ? this.persistenceManagerFactory.getClass() : (class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = LocalPersistenceManagerFactoryBean.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof JDOException) {
            if (this.jdoDialect != null) {
                return this.jdoDialect.translateException((JDOException)((Object)ex));
            }
            return PersistenceManagerFactoryUtils.convertJdoAccessException((JDOException)((Object)ex));
        }
        return null;
    }

    public void destroy() {
        this.logger.info((Object)"Closing JDO PersistenceManagerFactory");
        this.persistenceManagerFactory.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

