/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.messaging.rsocket.service.RSocketExchange;
import org.springframework.messaging.rsocket.service.RSocketRequestValues;
import org.springframework.messaging.rsocket.service.RSocketServiceArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class RSocketServiceMethod {
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private final Method method;
    private final MethodParameter[] parameters;
    private final List<RSocketServiceArgumentResolver> argumentResolvers;
    private final @Nullable String route;
    private final Function<RSocketRequestValues, Object> responseFunction;

    RSocketServiceMethod(Method method, Class<?> containingClass, List<RSocketServiceArgumentResolver> argumentResolvers, RSocketRequester rsocketRequester, @Nullable StringValueResolver embeddedValueResolver, ReactiveAdapterRegistry reactiveRegistry, @Nullable Duration blockTimeout) {
        this.method = method;
        this.parameters = RSocketServiceMethod.initMethodParameters(method);
        this.argumentResolvers = argumentResolvers;
        this.route = RSocketServiceMethod.initRoute(method, containingClass, rsocketRequester.strategies(), embeddedValueResolver);
        this.responseFunction = RSocketServiceMethod.initResponseFunction(rsocketRequester, method, reactiveRegistry, blockTimeout);
    }

    private static MethodParameter[] initMethodParameters(Method method) {
        int count = method.getParameterCount();
        if (count == 0) {
            return new MethodParameter[0];
        }
        if (KotlinDetector.isSuspendingFunction((Method)method)) {
            --count;
        }
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i2 = 0; i2 < count; ++i2) {
            parameters[i2] = new SynthesizingMethodParameter(method, i2);
        }
        return parameters;
    }

    private static @Nullable String initRoute(Method method, Class<?> containingClass, RSocketStrategies strategies, @Nullable StringValueResolver embeddedValueResolver) {
        RSocketExchange annot1 = (RSocketExchange)AnnotatedElementUtils.findMergedAnnotation(containingClass, RSocketExchange.class);
        RSocketExchange annot2 = (RSocketExchange)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RSocketExchange.class);
        Assert.notNull((Object)annot2, (String)"Expected RSocketExchange annotation");
        String route1 = annot1 != null ? annot1.value() : null;
        String route2 = annot2.value();
        if (embeddedValueResolver != null) {
            route1 = route1 != null ? embeddedValueResolver.resolveStringValue(route1) : null;
            route2 = embeddedValueResolver.resolveStringValue(route2);
        }
        boolean hasRoute1 = StringUtils.hasText((String)route1);
        boolean hasRoute2 = StringUtils.hasText((String)route2);
        if (hasRoute1 && hasRoute2) {
            return strategies.routeMatcher().combine(route1, route2);
        }
        if (!hasRoute1 && !hasRoute2) {
            return null;
        }
        return hasRoute2 ? route2 : route1;
    }

    private static Function<RSocketRequestValues, Object> initResponseFunction(RSocketRequester requester, Method method, ReactiveAdapterRegistry reactiveRegistry, @Nullable Duration blockTimeout) {
        Function<RSocketRequestValues, Publisher> responseFunction;
        Class actualType;
        ReactiveAdapter reactiveAdapter;
        boolean isUnwrapped;
        MethodParameter returnParam = new MethodParameter(method, -1);
        Class returnType = returnParam.getParameterType();
        boolean isSuspending = KotlinDetector.isSuspendingFunction((Method)method);
        boolean hasFlowReturnType = COROUTINES_FLOW_CLASS_NAME.equals(returnType.getName());
        boolean bl = isUnwrapped = isSuspending && !hasFlowReturnType;
        if (isSuspending) {
            returnType = hasFlowReturnType ? Flux.class : Mono.class;
        }
        MethodParameter actualParam = (reactiveAdapter = reactiveRegistry.getAdapter(returnType)) != null ? returnParam.nested() : returnParam.nestedIfOptional();
        Class clazz = actualType = isUnwrapped ? actualParam.getParameterType() : actualParam.getNestedParameterType();
        if (ClassUtils.isVoidType((Class)actualType) || reactiveAdapter != null && reactiveAdapter.isNoValue()) {
            responseFunction = values -> {
                RSocketRequester.RetrieveSpec retrieveSpec = RSocketServiceMethod.initRequest(requester, values);
                return values.getPayload() == null && values.getPayloadValue() == null ? ((RSocketRequester.RequestSpec)retrieveSpec).sendMetadata() : retrieveSpec.send();
            };
        } else if (reactiveAdapter == null) {
            responseFunction = values -> RSocketServiceMethod.initRequest(requester, values).retrieveMono(actualType);
        } else {
            ParameterizedTypeReference payloadType = ParameterizedTypeReference.forType((Type)(isUnwrapped ? actualParam.getGenericParameterType() : actualParam.getNestedGenericParameterType()));
            responseFunction = values -> reactiveAdapter.isMultiValue() ? RSocketServiceMethod.initRequest(requester, values).retrieveFlux(payloadType) : RSocketServiceMethod.initRequest(requester, values).retrieveMono(payloadType);
        }
        boolean blockForOptional = returnType.equals(Optional.class);
        return responseFunction.andThen(responsePublisher -> {
            if (reactiveAdapter != null) {
                return reactiveAdapter.fromPublisher(responsePublisher);
            }
            if (blockForOptional) {
                return blockTimeout != null ? ((Mono)responsePublisher).blockOptional(blockTimeout) : ((Mono)responsePublisher).blockOptional();
            }
            return Objects.requireNonNull(blockTimeout != null ? ((Mono)responsePublisher).block(blockTimeout) : ((Mono)responsePublisher).block());
        });
    }

    private static RSocketRequester.RetrieveSpec initRequest(RSocketRequester requester, RSocketRequestValues requestValues) {
        RSocketRequester.RequestSpec spec;
        String route = requestValues.getRoute();
        Map<Object, MimeType> metadata = requestValues.getMetadata();
        if (StringUtils.hasText((String)route)) {
            spec = requester.route(route, requestValues.getRouteVariables());
            for (Map.Entry<Object, MimeType> entry : metadata.entrySet()) {
                spec.metadata(entry.getKey(), entry.getValue());
            }
        } else {
            Iterator<Map.Entry<Object, MimeType>> iterator = metadata.entrySet().iterator();
            Assert.isTrue((boolean)iterator.hasNext(), (String)"Neither route nor metadata provided");
            Map.Entry<Object, MimeType> entry = iterator.next();
            spec = requester.metadata(entry.getKey(), entry.getValue());
            while (iterator.hasNext()) {
                spec.metadata(entry.getKey(), entry.getValue());
            }
        }
        if (requestValues.getPayloadValue() != null) {
            spec.data(requestValues.getPayloadValue());
        } else if (requestValues.getPayload() != null) {
            Assert.notNull(requestValues.getPayloadElementType(), (String)"Publisher body element type is required");
            spec.data(requestValues.getPayload(), requestValues.getPayloadElementType());
        }
        return spec;
    }

    public Method getMethod() {
        return this.method;
    }

    public @Nullable Object invoke(@Nullable Object[] arguments) {
        RSocketRequestValues.Builder requestValues = RSocketRequestValues.builder(this.route);
        this.applyArguments(requestValues, arguments);
        return this.responseFunction.apply(requestValues.build());
    }

    private void applyArguments(RSocketRequestValues.Builder requestValues, @Nullable Object[] arguments) {
        Assert.isTrue((arguments.length == this.parameters.length ? 1 : 0) != 0, (String)"Method argument mismatch");
        int i2 = 0;
        while (i2 < arguments.length) {
            Object value = arguments[i2];
            boolean resolved = false;
            for (RSocketServiceArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.resolve(value, this.parameters[i2], requestValues)) continue;
                resolved = true;
                break;
            }
            int index = i2++;
            Assert.state((boolean)resolved, () -> RSocketServiceMethod.formatArgumentError(this.parameters[index], "No suitable resolver"));
        }
    }

    private static String formatArgumentError(MethodParameter param, String message) {
        return "Could not resolve parameter [" + param.getParameterIndex() + "] in " + param.getExecutable().toGenericString() + (String)(StringUtils.hasText((String)message) ? ": " + message : "");
    }
}

