/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

public class MockFilterConfig
implements FilterConfig {
    private final ServletContext servletContext;
    private final String filterName;
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();

    public MockFilterConfig() {
        this(null, "");
    }

    public MockFilterConfig(String filterName) {
        this(null, filterName);
    }

    public MockFilterConfig(@Nullable ServletContext servletContext) {
        this(servletContext, "");
    }

    public MockFilterConfig(@Nullable ServletContext servletContext, String filterName) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.filterName = filterName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.initParameters.put(name, value);
    }

    @Nullable
    public String getInitParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }
}

