/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.JettyHeadersAdapter;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class JettyClientHttpRequest
extends AbstractClientHttpRequest {
    private final Request jettyRequest;
    private final DataBufferFactory bufferFactory;
    private final ReactiveRequest.Builder builder;

    public JettyClientHttpRequest(Request jettyRequest, DataBufferFactory bufferFactory) {
        this.jettyRequest = jettyRequest;
        this.bufferFactory = bufferFactory;
        this.builder = ReactiveRequest.newBuilder((Request)this.jettyRequest).abortOnCancel(true);
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.jettyRequest.getMethod());
    }

    @Override
    public URI getURI() {
        return this.jettyRequest.getURI();
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit();
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.jettyRequest;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return Mono.create(sink -> {
            ReactiveRequest.Content content = (ReactiveRequest.Content)Flux.from((Publisher)body).map(buffer -> this.toContentChunk((DataBuffer)buffer, (MonoSink<Void>)sink)).as(chunks -> ReactiveRequest.Content.fromPublisher((Publisher)chunks, (String)this.getContentType()));
            this.builder.content(content);
            sink.success();
        }).then(this.doCommit());
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMap(Function.identity()).doOnDiscard(DataBuffer.class, DataBufferUtils::release));
    }

    private String getContentType() {
        MediaType contentType = this.getHeaders().getContentType();
        return contentType != null ? contentType.toString() : "application/octet-stream";
    }

    private ContentChunk toContentChunk(final DataBuffer dataBuffer, final MonoSink<Void> sink) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(dataBuffer.readableByteCount());
        dataBuffer.toByteBuffer(byteBuffer);
        return new ContentChunk(byteBuffer, new Callback(){

            public void succeeded() {
                DataBufferUtils.release((DataBuffer)dataBuffer);
            }

            public void failed(Throwable t) {
                DataBufferUtils.release((DataBuffer)dataBuffer);
                sink.error(t);
            }
        });
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> new HttpCookie(cookie.getName(), cookie.getValue())).forEach(arg_0 -> ((Request)this.jettyRequest).cookie(arg_0));
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        this.jettyRequest.headers(fields -> {
            headers.forEach((key, value) -> value.forEach(v -> fields.add(key, v)));
            if (!headers.containsKey("Accept")) {
                fields.add("Accept", "*/*");
            }
        });
    }

    @Override
    protected HttpHeaders initReadOnlyHeaders() {
        return HttpHeaders.readOnlyHttpHeaders(new JettyHeadersAdapter(this.jettyRequest.getHeaders()));
    }

    public ReactiveRequest toReactiveRequest() {
        return this.builder.build();
    }
}

