/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.NativeWebRequest;

public class DefaultDataBinderFactory
implements WebDataBinderFactory {
    @Nullable
    private final WebBindingInitializer initializer;
    private boolean methodValidationApplicable;

    public DefaultDataBinderFactory(@Nullable WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public void setMethodValidationApplicable(boolean methodValidationApplicable) {
        this.methodValidationApplicable = methodValidationApplicable;
    }

    @Override
    public final WebDataBinder createBinder(NativeWebRequest webRequest, @Nullable Object target, String objectName) throws Exception {
        WebDataBinder dataBinder = this.createBinderInstance(target, objectName, webRequest);
        if (this.initializer != null) {
            this.initializer.initBinder(dataBinder);
        }
        this.initBinder(dataBinder, webRequest);
        return dataBinder;
    }

    protected WebDataBinder createBinderInstance(@Nullable Object target, String objectName, NativeWebRequest webRequest) throws Exception {
        return new WebRequestDataBinder(target, objectName);
    }

    protected void initBinder(WebDataBinder dataBinder, NativeWebRequest webRequest) throws Exception {
    }

    @Override
    public WebDataBinder createBinder(NativeWebRequest webRequest, @Nullable Object target, String objectName, MethodParameter parameter) throws Exception {
        WebDataBinder dataBinder = this.createBinder(webRequest, target, objectName);
        if (this.methodValidationApplicable) {
            MethodValidationInitializer.updateBinder(dataBinder, parameter);
        }
        return dataBinder;
    }

    private static class MethodValidationInitializer {
        private MethodValidationInitializer() {
        }

        public static void updateBinder(DataBinder binder, MethodParameter parameter) {
            for (Annotation annotation : parameter.getParameterAnnotations()) {
                if (!annotation.annotationType().getName().equals("jakarta.validation.Valid")) continue;
                binder.setExcludedValidators(validator -> validator instanceof Validator);
            }
        }
    }
}

