/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ProblemDetail {
    private static final URI BLANK_TYPE = URI.create("about:blank");
    private URI type = BLANK_TYPE;
    @Nullable
    private String title;
    private int status;
    @Nullable
    private String detail;
    @Nullable
    private URI instance;
    @Nullable
    private Map<String, Object> properties;

    protected ProblemDetail(int rawStatusCode) {
        this.status = rawStatusCode;
    }

    protected ProblemDetail(ProblemDetail other) {
        this.type = other.type;
        this.title = other.title;
        this.status = other.status;
        this.detail = other.detail;
        this.instance = other.instance;
        this.properties = other.properties != null ? new LinkedHashMap<String, Object>(other.properties) : null;
    }

    protected ProblemDetail() {
    }

    public void setType(URI type) {
        Assert.notNull((Object)type, (String)"'type' is required");
        this.type = type;
    }

    public URI getType() {
        return this.type;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nullable
    public String getTitle() {
        HttpStatus httpStatus;
        if (this.title == null && (httpStatus = HttpStatus.resolve(this.status)) != null) {
            return httpStatus.getReasonPhrase();
        }
        return this.title;
    }

    public void setStatus(HttpStatus httpStatus) {
        this.status = httpStatus.value();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setDetail(@Nullable String detail) {
        this.detail = detail;
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    public void setInstance(@Nullable URI instance) {
        this.instance = instance;
    }

    @Nullable
    public URI getInstance() {
        return this.instance;
    }

    public void setProperty(String name, @Nullable Object value) {
        this.properties = this.properties != null ? this.properties : new LinkedHashMap<String, Object>();
        this.properties.put(name, value);
    }

    @Nullable
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ProblemDetail)) return false;
        ProblemDetail that = (ProblemDetail)other;
        if (!this.getType().equals(that.getType())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.getTitle(), (Object)that.getTitle())) return false;
        if (this.status != that.status) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.detail, (Object)that.detail)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.instance, (Object)that.instance)) return false;
        if (!ObjectUtils.nullSafeEquals(this.properties, that.properties)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.getTitle(), this.status, this.detail, this.instance, this.properties);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.initToStringContent() + "]";
    }

    protected String initToStringContent() {
        return "type='" + this.getType() + "', title='" + this.getTitle() + "', status=" + this.getStatus() + ", detail='" + this.getDetail() + "', instance='" + this.getInstance() + "', properties='" + this.getProperties() + "'";
    }

    public static ProblemDetail forStatus(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        return ProblemDetail.forStatus(status.value());
    }

    public static ProblemDetail forStatus(int status) {
        return new ProblemDetail(status);
    }

    public static ProblemDetail forStatusAndDetail(HttpStatusCode status, String detail) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        ProblemDetail problemDetail = ProblemDetail.forStatus(status.value());
        problemDetail.setDetail(detail);
        return problemDetail;
    }
}

