/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.accept.ApiVersionResolver;
import org.springframework.web.server.ServerWebExchange;

public class MediaTypeParamApiVersionResolver
implements ApiVersionResolver {
    private final MediaType compatibleMediaType;
    private final String parameterName;

    public MediaTypeParamApiVersionResolver(MediaType compatibleMediaType, String paramName) {
        this.compatibleMediaType = compatibleMediaType;
        this.parameterName = paramName;
    }

    @Override
    public @Nullable String resolveVersion(ServerWebExchange exchange2) {
        HttpHeaders headers = exchange2.getRequest().getHeaders();
        for (MediaType mediaType : headers.getAccept()) {
            if (!this.compatibleMediaType.isCompatibleWith(mediaType)) continue;
            return mediaType.getParameter(this.parameterName);
        }
        MediaType mediaType = headers.getContentType();
        if (mediaType != null && this.compatibleMediaType.isCompatibleWith(mediaType)) {
            return mediaType.getParameter(this.parameterName);
        }
        return null;
    }
}

