/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class WebSocketMessage {
    private final Type type;
    private final DataBuffer payload;
    private final @Nullable Object nativeMessage;

    public WebSocketMessage(Type type, DataBuffer payload) {
        this(type, payload, null);
    }

    public WebSocketMessage(Type type, DataBuffer payload, @Nullable Object nativeMessage) {
        Assert.notNull((Object)((Object)type), (String)"'type' must not be null");
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        this.type = type;
        this.payload = payload;
        this.nativeMessage = nativeMessage;
    }

    public Type getType() {
        return this.type;
    }

    public DataBuffer getPayload() {
        return this.payload;
    }

    public <T> @Nullable T getNativeMessage() {
        return (T)this.nativeMessage;
    }

    public String getPayloadAsText() {
        return this.getPayloadAsText(StandardCharsets.UTF_8);
    }

    public String getPayloadAsText(Charset charset) {
        return this.payload.toString(charset);
    }

    public WebSocketMessage retain() {
        DataBufferUtils.retain((DataBuffer)this.payload);
        return this;
    }

    public void release() {
        DataBufferUtils.release((DataBuffer)this.payload);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof WebSocketMessage)) return false;
        WebSocketMessage that = (WebSocketMessage)other;
        if (!this.type.equals((Object)that.type)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.payload, (Object)that.payload)) return false;
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() * 29 + this.payload.hashCode();
    }

    public String toString() {
        return "WebSocket " + this.type.name() + " message (" + this.payload.readableByteCount() + " bytes)";
    }

    public static enum Type {
        TEXT,
        BINARY,
        PING,
        PONG;

    }
}

