/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.reactive.result.view.AbstractView;
import reactor.core.publisher.Mono;

public abstract class AbstractUrlBasedView
extends AbstractView
implements InitializingBean {
    private @Nullable String url;

    protected AbstractUrlBasedView() {
    }

    protected AbstractUrlBasedView(String url) {
        this.url = url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public @Nullable String getUrl() {
        return this.url;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getUrl() == null) {
            throw new IllegalArgumentException("Property 'url' is required");
        }
    }

    public abstract boolean checkResourceExists(Locale var1) throws Exception;

    public Mono<Boolean> resourceExists(Locale locale) {
        return Mono.fromCallable(() -> this.checkResourceExists(locale));
    }

    @Override
    public String toString() {
        return super.toString() + "; URL [" + this.getUrl() + "]";
    }
}

