/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.PointcutParameter;
import org.springframework.aop.aspectj.AspectInstanceFactory;
import org.springframework.aop.aspectj.AspectJAdviceParameterNameDiscoverer;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.AspectJPrecedenceInformation;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.LocalVariableTableParameterNameDiscover;
import org.springframework.core.Ordered;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.util.StringUtils;

public abstract class AbstractAspectJAdvice
implements AspectJPrecedenceInformation,
InitializingBean {
    protected static final String JOIN_POINT_KEY = (class$org$aspectj$lang$JoinPoint == null ? (class$org$aspectj$lang$JoinPoint = AbstractAspectJAdvice.class$("org.aspectj.lang.JoinPoint")) : class$org$aspectj$lang$JoinPoint).getName();
    protected final Method aspectJAdviceMethod;
    private final AspectJExpressionPointcut pointcutExpression;
    private final AspectInstanceFactory aif;
    private String aspectName;
    private Object aspectBean;
    private int declarationOrder;
    private String[] argumentNames = null;
    private String throwingName = null;
    private String returningName = null;
    private Class discoveredReturningType = class$java$lang$Object == null ? (class$java$lang$Object = AbstractAspectJAdvice.class$("java.lang.Object")) : class$java$lang$Object;
    private Class discoveredThrowingType = class$java$lang$Object == null ? (class$java$lang$Object = AbstractAspectJAdvice.class$("java.lang.Object")) : class$java$lang$Object;
    private final int numAdviceInvocationArguments;
    private int joinPointArgumentIndex = -1;
    private int joinPointStaticPartArgumentIndex = -1;
    private final Map argumentBindings = new HashMap();
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$aspectj$lang$ProceedingJoinPoint;
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint$StaticPart;

    public static JoinPoint currentJoinPoint() {
        ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)ExposeInvocationInterceptor.currentInvocation();
        Object jp = (JoinPoint)rmi.getUserAttributes().get(JOIN_POINT_KEY);
        if (jp == null) {
            jp = new MethodInvocationProceedingJoinPoint(rmi);
            rmi.getUserAttributes().put(JOIN_POINT_KEY, jp);
        }
        return jp;
    }

    public AbstractAspectJAdvice(Method aspectJAdviceMethod, AspectJExpressionPointcut pointcutExpression, AspectInstanceFactory aif) {
        this.aspectJAdviceMethod = aspectJAdviceMethod;
        if (!aspectJAdviceMethod.isAccessible()) {
            aspectJAdviceMethod.setAccessible(true);
        }
        this.numAdviceInvocationArguments = this.aspectJAdviceMethod.getParameterTypes().length;
        this.pointcutExpression = pointcutExpression;
        this.aif = aif;
    }

    public Method getAspectJAdviceMethod() {
        return this.aspectJAdviceMethod;
    }

    public AspectJExpressionPointcut getPointcut() {
        return this.pointcutExpression;
    }

    public void setAspectName(String name) {
        this.aspectName = name;
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public void setAspectBean(Object bean) {
        this.aspectBean = bean;
    }

    public int getOrder() {
        if (this.aspectBean != null && this.aspectBean instanceof Ordered) {
            return ((Ordered)this.aspectBean).getOrder();
        }
        return Integer.MAX_VALUE;
    }

    public void setDeclarationOrder(int order) {
        this.declarationOrder = order;
    }

    public int getDeclarationOrder() {
        return this.declarationOrder;
    }

    public void setArgumentNames(String argNames) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray(argNames);
        this.setArgumentNamesFromStringArray(tokens);
    }

    public void setArgumentNamesFromStringArray(String[] args) {
        this.argumentNames = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.argumentNames[i] = StringUtils.trimWhitespace(args[i]);
            if (this.isVariableName(this.argumentNames[i])) continue;
            throw new IllegalArgumentException("argumentNames property of AbstractAspectJAdvice contains an argument name '" + this.argumentNames[i] + "' that is not a valid Java identifier");
        }
    }

    public void setReturningName(String name) {
        throw new UnsupportedOperationException("Only afterReturning advice can be used to bind a return value");
    }

    protected void setReturningNameNoCheck(String name) {
        if (this.isVariableName(name)) {
            this.returningName = name;
        } else {
            try {
                this.discoveredReturningType = Class.forName(name);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Returning name '" + name + "' is neither a valid argument name, nor the fully-qualified name of the Java type on the classpath");
            }
        }
    }

    protected Class getDiscoveredReturningType() {
        return this.discoveredReturningType;
    }

    public void setThrowingName(String name) {
        throw new UnsupportedOperationException("Only afterThrowing advice can be used to bind a thrown exception");
    }

    protected void setThrowingNameNoCheck(String name) {
        if (this.isVariableName(name)) {
            this.throwingName = name;
        } else {
            try {
                this.discoveredThrowingType = Class.forName(name);
            }
            catch (ClassNotFoundException cnfEx) {
                throw new IllegalArgumentException("Throwing name '" + name + "' is neither a valid argument name, nor the fully-qualified name of the Java type on the classpath");
            }
        }
    }

    protected Class getDiscoveredThrowingType() {
        return this.discoveredThrowingType;
    }

    private boolean isVariableName(String name) {
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.calculateArgumentBindings();
    }

    private void calculateArgumentBindings() {
        if (this.numAdviceInvocationArguments == 0) {
            return;
        }
        int numUnboundArgs = this.numAdviceInvocationArguments;
        Class<?>[] parameterTypes = this.aspectJAdviceMethod.getParameterTypes();
        if (this.maybeBindJoinPoint(parameterTypes[0])) {
            --numUnboundArgs;
        } else if (this.maybeBindJoinPointStaticPart(parameterTypes[0])) {
            --numUnboundArgs;
        }
        if (numUnboundArgs > 0) {
            this.bindArgumentsByName(numUnboundArgs);
        }
    }

    private boolean maybeBindJoinPoint(Class candidateParameterType) {
        if (candidateParameterType.equals(class$org$aspectj$lang$JoinPoint == null ? (class$org$aspectj$lang$JoinPoint = AbstractAspectJAdvice.class$("org.aspectj.lang.JoinPoint")) : class$org$aspectj$lang$JoinPoint) || candidateParameterType.equals(class$org$aspectj$lang$ProceedingJoinPoint == null ? (class$org$aspectj$lang$ProceedingJoinPoint = AbstractAspectJAdvice.class$("org.aspectj.lang.ProceedingJoinPoint")) : class$org$aspectj$lang$ProceedingJoinPoint)) {
            this.joinPointArgumentIndex = 0;
            return true;
        }
        return false;
    }

    private boolean maybeBindJoinPointStaticPart(Class candidateParameterType) {
        if (candidateParameterType.equals(class$org$aspectj$lang$JoinPoint$StaticPart == null ? (class$org$aspectj$lang$JoinPoint$StaticPart = AbstractAspectJAdvice.class$("org.aspectj.lang.JoinPoint$StaticPart")) : class$org$aspectj$lang$JoinPoint$StaticPart)) {
            this.joinPointStaticPartArgumentIndex = 0;
            return true;
        }
        return false;
    }

    private void bindArgumentsByName(int numArgumentsExpectingToBind) {
        if (this.argumentNames == null) {
            PrioritizedParameterNameDiscoverer discoverer = new PrioritizedParameterNameDiscoverer();
            discoverer.addDiscoverer(new LocalVariableTableParameterNameDiscover());
            AspectJAdviceParameterNameDiscoverer adviceParameterNameDiscoverer = new AspectJAdviceParameterNameDiscoverer(this.pointcutExpression.getExpression());
            adviceParameterNameDiscoverer.setReturningName(this.returningName);
            adviceParameterNameDiscoverer.setThrowingName(this.throwingName);
            adviceParameterNameDiscoverer.setRaiseExceptions(true);
            discoverer.addDiscoverer(adviceParameterNameDiscoverer);
            this.argumentNames = discoverer.getParameterNames(this.aspectJAdviceMethod);
        }
        if (this.argumentNames == null) {
            throw new IllegalStateException("Advice method [" + this.aspectJAdviceMethod.getName() + "] " + "requires " + numArgumentsExpectingToBind + " arguments to be bound by name, but " + "the argument names were not specified and could not be discovered.");
        }
        this.bindExplicitArguments(numArgumentsExpectingToBind);
    }

    private void bindExplicitArguments(int numArgumentsLeftToBind) {
        int argumentIndexOffset;
        int numExpectedArgumentNames = this.aspectJAdviceMethod.getParameterTypes().length;
        if (this.argumentNames.length != numExpectedArgumentNames) {
            throw new IllegalStateException("Expecting to find " + numExpectedArgumentNames + " arguments to bind by name in advice, but actually found " + this.argumentNames.length + " arguments.");
        }
        for (int i = argumentIndexOffset = this.numAdviceInvocationArguments - numArgumentsLeftToBind; i < this.argumentNames.length; ++i) {
            this.argumentBindings.put(this.argumentNames[i], new Integer(i));
        }
        if (this.returningName != null) {
            if (!this.argumentBindings.containsKey(this.returningName)) {
                throw new IllegalStateException("Returning argument name '" + this.returningName + "' was not bound in advice arguments");
            }
            Integer index = (Integer)this.argumentBindings.get(this.returningName);
            this.discoveredReturningType = this.aspectJAdviceMethod.getParameterTypes()[index];
        }
        if (this.throwingName != null) {
            if (!this.argumentBindings.containsKey(this.throwingName)) {
                throw new IllegalStateException("Throwing argument name '" + this.throwingName + "' was not bound in advice arguments");
            }
            Integer index = (Integer)this.argumentBindings.get(this.throwingName);
            this.discoveredThrowingType = this.aspectJAdviceMethod.getParameterTypes()[index];
        }
        this.configurePointcutParameters(argumentIndexOffset);
    }

    private void configurePointcutParameters(int argumentIndexOffset) {
        int numParametersToRemove = argumentIndexOffset;
        if (this.returningName != null) {
            ++numParametersToRemove;
        }
        if (this.throwingName != null) {
            ++numParametersToRemove;
        }
        String[] pointcutParameterNames = new String[this.argumentNames.length - numParametersToRemove];
        Class[] pointcutParameterTypes = new Class[pointcutParameterNames.length];
        Class<?>[] methodParameterTypes = this.aspectJAdviceMethod.getParameterTypes();
        int index = 0;
        for (int i = 0; i < this.argumentNames.length; ++i) {
            if (i < argumentIndexOffset || this.argumentNames[i].equals(this.returningName) || this.argumentNames[i].equals(this.throwingName)) continue;
            pointcutParameterNames[index] = this.argumentNames[i];
            pointcutParameterTypes[index] = methodParameterTypes[i];
            ++index;
        }
        this.pointcutExpression.setParameterNames(pointcutParameterNames);
        this.pointcutExpression.setParameterTypes(pointcutParameterTypes);
    }

    protected Object[] argBinding(JoinPoint jp, JoinPointMatch jpMatch, Object returnValue, Throwable t) {
        Object[] adviceInvocationArgs = new Object[this.numAdviceInvocationArguments];
        int numBound = 0;
        if (this.joinPointArgumentIndex != -1) {
            adviceInvocationArgs[this.joinPointArgumentIndex] = jp;
            ++numBound;
        } else if (this.joinPointStaticPartArgumentIndex != -1) {
            adviceInvocationArgs[this.joinPointStaticPartArgumentIndex] = jp.getStaticPart();
            ++numBound;
        }
        if (!this.argumentBindings.isEmpty()) {
            Integer index;
            if (jpMatch != null) {
                PointcutParameter[] parameterBindings = jpMatch.getParameterBindings();
                for (int i = 0; i < parameterBindings.length; ++i) {
                    PointcutParameter parameter = parameterBindings[i];
                    String name = parameter.getName();
                    Integer index2 = (Integer)this.argumentBindings.get(name);
                    adviceInvocationArgs[index2.intValue()] = parameter.getBinding();
                    ++numBound;
                }
            }
            if (this.returningName != null) {
                index = (Integer)this.argumentBindings.get(this.returningName);
                adviceInvocationArgs[index.intValue()] = returnValue;
                ++numBound;
            }
            if (this.throwingName != null) {
                index = (Integer)this.argumentBindings.get(this.throwingName);
                adviceInvocationArgs[index.intValue()] = t;
                ++numBound;
            }
        }
        if (numBound != this.numAdviceInvocationArguments) {
            throw new IllegalStateException("Required to bind " + this.numAdviceInvocationArguments + " arguments, but only bound " + numBound + " (JoinPointMatch " + (jpMatch == null ? "was NOT" : "WAS") + " bound in invocation)");
        }
        return adviceInvocationArgs;
    }

    protected JoinPoint getJoinPoint() {
        return AbstractAspectJAdvice.currentJoinPoint();
    }

    protected JoinPointMatch getJoinPointMatch() {
        ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)ExposeInvocationInterceptor.currentInvocation();
        return this.getJoinPointMatch(rmi);
    }

    protected JoinPointMatch getJoinPointMatch(ReflectiveMethodInvocation rmi) {
        JoinPointMatch jpm = (JoinPointMatch)rmi.getUserAttributes().get(this.pointcutExpression.getExpression());
        return jpm;
    }

    protected Object invokeAdviceMethod(JoinPointMatch jpMatch, Object returnValue, Throwable t) throws Throwable {
        return this.invokeAdviceMethodWithGivenArgs(this.argBinding(this.getJoinPoint(), jpMatch, returnValue, t));
    }

    protected Object invokeAdviceMethod(JoinPoint jp, JoinPointMatch jpMatch, Object returnValue, Throwable t) throws Throwable {
        return this.invokeAdviceMethodWithGivenArgs(this.argBinding(jp, jpMatch, returnValue, t));
    }

    protected Object invokeAdviceMethodWithGivenArgs(Object[] args) throws Throwable {
        if (this.aspectJAdviceMethod.getParameterTypes().length == 0) {
            args = null;
        }
        try {
            return this.aspectJAdviceMethod.invoke(this.aif.getAspectInstance(), args);
        }
        catch (IllegalArgumentException ex) {
            throw new AopConfigException("Mismatch on arguments to advice method [" + this.aspectJAdviceMethod + "]; " + "pointcut expression = [" + this.pointcutExpression.getPointcutExpression() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public String toString() {
        return this.getClass().getName() + ": adviceMethod=" + this.aspectJAdviceMethod + "; " + "aspectName='" + this.aspectName + "'";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

