/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.jruby;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.Ruby;
import org.jruby.RubyNil;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.util.ClassUtils;

public abstract class JRubyScriptUtils {
    public static Object createJRubyObject(String scriptSource, Class[] interfaces) throws JumpException {
        Node scriptRootNode;
        IRuby ruby = Ruby.getDefaultInstance();
        IRubyObject rubyObject = ruby.eval(scriptRootNode = ruby.parse(scriptSource, ""));
        if (rubyObject instanceof RubyNil) {
            String className = JRubyScriptUtils.findClassName(scriptRootNode);
            rubyObject = ruby.evalScript("\n" + className + ".new");
        }
        if (rubyObject instanceof RubyNil) {
            throw new ScriptCompilationException("Compilation of JRuby script returned '" + rubyObject + "'");
        }
        return Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), interfaces, (InvocationHandler)new RubyObjectInvocationHandler(rubyObject, ruby));
    }

    private static String findClassName(Node rootNode) {
        ClassNode classNode = JRubyScriptUtils.findClassNode(rootNode);
        if (classNode == null) {
            throw new IllegalArgumentException("Unable to determine class name for root node '" + rootNode + "'");
        }
        Colon2Node node = (Colon2Node)classNode.getCPath();
        return node.getName();
    }

    private static ClassNode findClassNode(Node node) {
        Node child;
        int i;
        if (node instanceof ClassNode) {
            return (ClassNode)node;
        }
        List children = node.childNodes();
        for (i = 0; i < children.size(); ++i) {
            NewlineNode nn;
            ClassNode found;
            child = (Node)children.get(i);
            if (child instanceof ClassNode) {
                return (ClassNode)child;
            }
            if (!(child instanceof NewlineNode) || !((found = JRubyScriptUtils.findClassNode((nn = (NewlineNode)child).getNextNode())) instanceof ClassNode)) continue;
            return found;
        }
        for (i = 0; i < children.size(); ++i) {
            child = (Node)children.get(i);
            ClassNode found = JRubyScriptUtils.findClassNode(child);
            if (!(found instanceof ClassNode)) continue;
            return (ClassNode)child;
        }
        return null;
    }

    private static class RubyObjectInvocationHandler
    implements InvocationHandler {
        private final IRubyObject rubyObject;
        private final IRuby ruby;

        public RubyObjectInvocationHandler(IRubyObject rubyObject, IRuby ruby) {
            this.rubyObject = rubyObject;
            this.ruby = ruby;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            IRubyObject[] rubyArgs = this.convertToRuby(args);
            IRubyObject result = this.rubyObject.callMethod(method.getName(), rubyArgs);
            return JavaUtil.convertRubyToJava((IRubyObject)result);
        }

        private IRubyObject[] convertToRuby(Object[] javaArgs) {
            if (javaArgs == null || javaArgs.length == 0) {
                return new IRubyObject[0];
            }
            return JavaUtil.convertJavaArrayToRuby((IRuby)this.ruby, (Object[])javaArgs);
        }
    }
}

