/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.PatternMatchUtils;

public class NameMatchTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = NameMatchTransactionAttributeSource.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource));
    private Map nameMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource;

    public void setNameMap(Map nameMap) {
        Iterator it = nameMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            TransactionAttribute attr = null;
            if (entry.getValue() instanceof TransactionAttribute) {
                attr = (TransactionAttribute)entry.getValue();
            } else {
                TransactionAttributeEditor editor = new TransactionAttributeEditor();
                editor.setAsText(entry.getValue().toString());
                attr = (TransactionAttribute)editor.getValue();
            }
            this.addTransactionalMethod(name, attr);
        }
    }

    public void setProperties(Properties transactionAttributes) {
        TransactionAttributeEditor tae = new TransactionAttributeEditor();
        Iterator<Object> it = transactionAttributes.keySet().iterator();
        while (it.hasNext()) {
            String methodName = (String)it.next();
            String value = transactionAttributes.getProperty(methodName);
            tae.setAsText(value);
            TransactionAttribute attr = (TransactionAttribute)tae.getValue();
            this.addTransactionalMethod(methodName, attr);
        }
    }

    public void addTransactionalMethod(String methodName, TransactionAttribute attr) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding transactional method [" + methodName + "] with attribute [" + attr + "]"));
        }
        this.nameMap.put(methodName, attr);
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        String methodName = method.getName();
        TransactionAttribute attr = (TransactionAttribute)this.nameMap.get(methodName);
        if (attr == null) {
            String bestNameMatch = null;
            Iterator it = this.nameMap.keySet().iterator();
            while (it.hasNext()) {
                String mappedName = (String)it.next();
                if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
                attr = (TransactionAttribute)this.nameMap.get(mappedName);
                bestNameMatch = mappedName;
            }
        }
        return attr;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

