/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;

public class BeanPropertyBindingResult
extends AbstractPropertyBindingResult
implements Serializable {
    private final Object target;
    private transient BeanWrapper beanWrapper;

    public BeanPropertyBindingResult(Object target, String objectName) {
        super(objectName);
        Assert.notNull(target, "Target bean must not be null");
        this.target = target;
    }

    public Object getTarget() {
        return this.target;
    }

    protected String canonicalFieldName(String field) {
        return BeanUtils.canonicalPropertyName(field);
    }

    public ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.beanWrapper == null) {
            this.beanWrapper = new BeanWrapperImpl(this.target);
            this.beanWrapper.setExtractOldValueForEditor(true);
        }
        return this.beanWrapper;
    }
}

