/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.scope.RequestScope;
import org.springframework.web.context.scope.SessionScope;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.portlet.context.ConfigurablePortletApplicationContext;
import org.springframework.web.portlet.context.PortletContextAwareProcessor;
import org.springframework.web.portlet.context.PortletContextResource;
import org.springframework.web.portlet.context.PortletContextResourcePatternResolver;

public abstract class AbstractRefreshablePortletApplicationContext
extends AbstractRefreshableApplicationContext
implements WebApplicationContext,
ConfigurablePortletApplicationContext {
    private ServletContext servletContext;
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private String namespace;
    private String[] configLocations;
    static /* synthetic */ Class class$org$springframework$web$context$ServletContextAware;
    static /* synthetic */ Class class$org$springframework$web$portlet$context$PortletContextAware;
    static /* synthetic */ Class class$org$springframework$web$portlet$context$PortletConfigAware;

    public AbstractRefreshablePortletApplicationContext() {
        this.setDisplayName("Root PortletApplicationContext");
    }

    public void setParent(ApplicationContext parent) {
        super.setParent(parent);
        if (parent instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)parent).getServletContext();
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
        if (portletConfig != null && this.portletContext == null) {
            this.portletContext = portletConfig.getPortletContext();
        }
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("PortletApplicationContext for namespace '" + namespace + "'");
        }
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    public void refresh() throws BeansException {
        if (this.configLocations == null || this.configLocations.length == 0) {
            this.setConfigLocations(this.getDefaultConfigLocations());
        }
        super.refresh();
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope("request", new RequestScope());
        beanFactory.registerScope("session", new SessionScope(false));
        beanFactory.registerScope("globalSession", new SessionScope(true));
        beanFactory.addBeanPostProcessor(new ServletContextAwareProcessor(this.servletContext));
        beanFactory.addBeanPostProcessor(new PortletContextAwareProcessor(this.portletContext, this.portletConfig));
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletContextAware == null ? (class$org$springframework$web$context$ServletContextAware = AbstractRefreshablePortletApplicationContext.class$("org.springframework.web.context.ServletContextAware")) : class$org$springframework$web$context$ServletContextAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$portlet$context$PortletContextAware == null ? (class$org$springframework$web$portlet$context$PortletContextAware = AbstractRefreshablePortletApplicationContext.class$("org.springframework.web.portlet.context.PortletContextAware")) : class$org$springframework$web$portlet$context$PortletContextAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$portlet$context$PortletConfigAware == null ? (class$org$springframework$web$portlet$context$PortletConfigAware = AbstractRefreshablePortletApplicationContext.class$("org.springframework.web.portlet.context.PortletConfigAware")) : class$org$springframework$web$portlet$context$PortletConfigAware);
    }

    protected Resource getResourceByPath(String path) {
        return new PortletContextResource(this.portletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PortletContextResourcePatternResolver(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("; ");
        sb.append("config locations [");
        sb.append(StringUtils.arrayToCommaDelimitedString(this.configLocations));
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

