/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.portlet.handler.AbstractHandlerMapping;

public class ParameterHandlerMapping
extends AbstractHandlerMapping {
    public static final String DEFAULT_PARAMETER_NAME = "action";
    private String parameterName = "action";
    private Map parameterMap;
    private boolean lazyInitHandlers = false;
    protected final Map handlerMap = new HashMap();

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterMap(Map parameterMap) {
        this.parameterMap = parameterMap;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public void initApplicationContext() throws BeansException {
        if (this.getParameterName() == null) {
            throw new IllegalArgumentException("A parameterName is required");
        }
        if (this.parameterMap == null || this.parameterMap.isEmpty()) {
            this.logger.warn((Object)"Neither 'parameterMap' nor 'mappings' set on ParameterHandlerMapping");
        } else {
            Iterator itr = this.parameterMap.keySet().iterator();
            while (itr.hasNext()) {
                String parameter = (String)itr.next();
                Object handler = this.parameterMap.get(parameter);
                this.registerHandler(parameter, handler);
            }
        }
    }

    protected void registerHandler(String parameter, Object handler) throws BeansException {
        Object mappedHandler = this.handlerMap.get(parameter);
        if (mappedHandler != null) {
            throw new ApplicationContextException("Cannot map handler [" + handler + "] to parameter value [" + parameter + "]: there's already handler [" + mappedHandler + "] mapped");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                handler = this.getApplicationContext().getBean(handlerName);
            }
        }
        this.handlerMap.put(parameter, handler);
        this.logger.info((Object)("Mapped parameter value [" + parameter + "] onto handler [" + handler + "]"));
    }

    protected Object getHandlerInternal(PortletRequest request) throws Exception {
        String parameter = request.getParameter(this.getParameterName());
        Object handler = this.handlerMap.get(parameter);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("parameter [" + parameter + "] = " + "handler [" + handler + "]"));
        }
        return handler;
    }
}

