/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import org.subethamail.smtp.command.AuthCommand;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.Session;

public class EhloCommand
extends BaseCommand {
    public EhloCommand() {
        super("EHLO", "Introduce yourself.", "<hostname>");
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        String[] args = this.getArgs(commandString);
        if (args.length < 2) {
            context.sendResponse("501 Syntax: EHLO hostname");
            return;
        }
        Session session = context.getSession();
        if (!session.getHasSeenHelo()) {
            session.setHasSeenHelo(true);
            String response = "250-" + context.getServer().getHostName() + "\r\n" + "250-8BITMIME";
            if (context.getServer().getCommandHandler().containsCommand("STARTTLS")) {
                response = response + "\r\n" + "250-STARTTLS";
            }
            if (context.getServer().getCommandHandler().containsCommand("AUTH")) {
                response = response + AuthCommand.getEhloString(context.getSession().getMessageHandler());
            }
            response = response + "\r\n" + "250 Ok";
            context.sendResponse(response);
        } else {
            String remoteHost = args[1];
            context.sendResponse("503 " + remoteHost + " Duplicate EHLO");
        }
    }
}

