/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.core;

import com.thoughtworks.xstream.XStream;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import org.thlws.payment.wechat.api.WechatApi;
import org.thlws.payment.wechat.entity.input.CloseOrderInput;
import org.thlws.payment.wechat.entity.input.OrderQueryInput;
import org.thlws.payment.wechat.entity.input.UnifiedOrderInput;
import org.thlws.payment.wechat.entity.input.WechatPayInput;
import org.thlws.payment.wechat.entity.input.WechatRefundInput;
import org.thlws.payment.wechat.entity.input.WechatReverseInput;
import org.thlws.payment.wechat.entity.output.CloseOrderOutput;
import org.thlws.payment.wechat.entity.output.OrderQueryOutput;
import org.thlws.payment.wechat.entity.output.UnifiedOrderOutput;
import org.thlws.payment.wechat.entity.output.WechatPayOutput;
import org.thlws.payment.wechat.entity.output.WechatRefundOutput;
import org.thlws.payment.wechat.entity.output.WechatReverseOutput;
import org.thlws.payment.wechat.extra.xml.XStreamCreator;
import org.thlws.payment.wechat.utils.ConnUtil;
import org.thlws.payment.wechat.utils.ThlwsBeanUtil;
import org.thlws.payment.wechat.utils.WechatUtil;

public class WechatCore
implements WechatApi {
    private static final Log log = LogFactory.get();

    public static UnifiedOrderOutput unifiedorder(UnifiedOrderInput data, String apiKey) {
        UnifiedOrderOutput output = null;
        try {
            Object input = WechatUtil.buildRequest(data, UnifiedOrderInput.class, apiKey);
            XStream xStream = XStreamCreator.create(UnifiedOrderInput.class);
            String xml = xStream.toXML(input);
            log.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42\u6570\u636e[unifiedorder]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/unifiedorder");
            log.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8fd4\u56de\u6570\u636e[unifiedorder]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            XStream xStreamOut = XStreamCreator.create(UnifiedOrderOutput.class);
            output = (UnifiedOrderOutput)xStreamOut.fromXML(xmlResponse);
        }
        catch (Exception e) {
            log.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355[unifiedorder]\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return output;
    }

    public static WechatRefundOutput refund(WechatRefundInput data, String apiKey, String p12FilePath) {
        WechatRefundOutput output = null;
        try {
            Object input = WechatUtil.buildRequest(data, WechatRefundInput.class, apiKey);
            XStream xStream = XStreamCreator.create(WechatRefundInput.class);
            String xml = xStream.toXML(input);
            log.info("\u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u6570\u636e[refund]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/pay/refund", data.getMch_id(), p12FilePath);
            log.info("\u5fae\u4fe1\u9000\u6b3e\u54cd\u5e94\u6570\u636e[refund]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            XStream xStreamOut = XStreamCreator.create(WechatRefundOutput.class);
            output = (WechatRefundOutput)xStreamOut.fromXML(xmlResponse);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u9000\u6b3e[refund]\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return output;
    }

    public static OrderQueryOutput orderQuery(OrderQueryInput data, String apiKey) {
        OrderQueryOutput output = null;
        try {
            Object input = WechatUtil.buildRequest(data, OrderQueryInput.class, apiKey);
            XStream xStream = XStreamCreator.create(OrderQueryInput.class);
            String xml = xStream.toXML(input);
            log.info("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u8bf7\u6c42\u6570\u636e[orderQuery]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/orderquery");
            log.info("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u54cd\u5e94\u6570\u636e[orderQuery]->response xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            XStream xStreamOut = XStreamCreator.create(OrderQueryOutput.class);
            output = (OrderQueryOutput)xStreamOut.fromXML(xmlResponse);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return output;
    }

    public static WechatReverseOutput reverse(WechatReverseInput data, String apiKey, String p12FilePath) {
        WechatReverseOutput output = null;
        try {
            Object input = WechatUtil.buildRequest(data, WechatReverseInput.class, apiKey);
            XStream xStream = XStreamCreator.create(WechatReverseInput.class);
            String xml = xStream.toXML(input);
            log.info("\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355\u8bf7\u6c42\u6570\u636e[reverse]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/pay/reverse", data.getMch_id(), p12FilePath);
            log.info("\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355\u54cd\u5e94\u6570\u636e[reverse]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            XStream xStreamOut = XStreamCreator.create(WechatReverseOutput.class);
            output = (WechatReverseOutput)xStreamOut.fromXML(xmlResponse);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355[reverse]\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return output;
    }

    public static CloseOrderOutput closeOrder(CloseOrderInput data, String apiKey) {
        CloseOrderOutput output = null;
        try {
            Object input = WechatUtil.buildRequest(data, CloseOrderInput.class, apiKey);
            XStream xStream = XStreamCreator.create(CloseOrderInput.class);
            String xml = xStream.toXML(input);
            log.info("\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355\u8bf7\u6c42\u6570\u636e[closeOrder]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/closeorder");
            log.info("\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355\u54cd\u5e94\u6570\u636e[closeOrder]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            XStream xStreamOut = XStreamCreator.create(CloseOrderOutput.class);
            output = (CloseOrderOutput)xStreamOut.fromXML(xmlResponse);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355[closeOrder]\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return output;
    }

    public static WechatPayOutput micropay(WechatPayInput data, String apiKey) {
        WechatPayOutput output = null;
        try {
            Object input = WechatUtil.buildRequest(data, WechatPayInput.class, apiKey);
            XStream xStream = XStreamCreator.create(WechatPayInput.class);
            String xml = xStream.toXML(input);
            log.info("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\u6570\u636e[micropay]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/micropay");
            log.info("\u5fae\u4fe1\u652f\u4ed8\u54cd\u5e94\u6570\u636e[micropay]->response xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            XStream xStreamOut = XStreamCreator.create(WechatPayOutput.class);
            output = (WechatPayOutput)xStreamOut.fromXML(xmlResponse);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u7ebf\u4e0b\u652f\u4ed8\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return output;
    }
}

