/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.portal.client;

import com.thoughtworks.xstream.XStream;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import java.util.Map;
import org.thlws.payment.wechat.api.WechatApi;
import org.thlws.payment.wechat.core.WechatCore;
import org.thlws.payment.wechat.entity.input.CloseOrderInput;
import org.thlws.payment.wechat.entity.input.MicroMchInput;
import org.thlws.payment.wechat.entity.input.OrderQueryInput;
import org.thlws.payment.wechat.entity.input.UnifiedOrderInput;
import org.thlws.payment.wechat.entity.input.WechatPayInput;
import org.thlws.payment.wechat.entity.input.WechatRefundInput;
import org.thlws.payment.wechat.entity.input.WechatReverseInput;
import org.thlws.payment.wechat.entity.output.CloseOrderOutput;
import org.thlws.payment.wechat.entity.output.MicroMchOutput;
import org.thlws.payment.wechat.entity.output.OrderQueryOutput;
import org.thlws.payment.wechat.entity.output.UnifiedOrderOutput;
import org.thlws.payment.wechat.entity.output.WechatPayOutput;
import org.thlws.payment.wechat.entity.output.WechatRefundOutput;
import org.thlws.payment.wechat.entity.output.WechatReverseOutput;
import org.thlws.payment.wechat.extra.xml.XStreamCreator;
import org.thlws.payment.wechat.utils.ConnUtil;
import org.thlws.payment.wechat.utils.ThlwsBeanUtil;
import org.thlws.payment.wechat.utils.WechatUtil;

public class WechatClient
implements WechatApi {
    private static final Log log = LogFactory.get();

    public static MicroMchOutput postMicroMch(MicroMchInput o, String apiKey, String p12FilePath) {
        MicroMchOutput resp = null;
        try {
            Map<String, Object> mapData = ThlwsBeanUtil.ObjectToMap(o);
            mapData = ThlwsBeanUtil.dataFilter(mapData);
            String sign = WechatUtil.sign(mapData, apiKey);
            mapData.put("sign", sign);
            MicroMchInput xwr = (MicroMchInput)ThlwsBeanUtil.mapToObject(mapData, MicroMchInput.class);
            String nonceStr = ThlwsBeanUtil.getRandomString(32);
            xwr.setNonce_str(nonceStr);
            XStream xStream = XStreamCreator.create(MicroMchInput.class);
            String xml = xStream.toXML((Object)xwr);
            log.info("\u7533\u8bf7\u5c0f\u5fae\u6536\u6b3e\u8bc6\u522b\u7801 [submchmanage] xml request:\n {}", new Object[]{xml});
            String xmlResp = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/mch/submchmanage?action=add", o.getMch_id(), p12FilePath);
            log.info("\u7533\u8bf7\u5c0f\u5fae\u6536\u6b3e\u8bc6\u522b\u7801 [submchmanage] xml response:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResp)});
            XStream xStreamOut = XStreamCreator.create(MicroMchOutput.class);
            resp = (MicroMchOutput)xStreamOut.fromXML(xmlResp);
        }
        catch (Exception e) {
            log.error("\u7533\u8bf7\u5c0f\u5fae\u6536\u6b3e\u8bc6\u522b\u7801\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return resp;
    }

    public static String queryMicroMch(MicroMchInput o, String apiKey, String p12FilePath) {
        String result = "";
        try {
            Map<String, Object> mapData = ThlwsBeanUtil.ObjectToMap(o);
            mapData = ThlwsBeanUtil.dataFilter(mapData);
            String sign = WechatUtil.sign(mapData, apiKey);
            mapData.put("sign", sign);
            MicroMchInput xwr = (MicroMchInput)ThlwsBeanUtil.mapToObject(mapData, MicroMchInput.class);
            xwr.setNonce_str(ThlwsBeanUtil.getRandomString(32));
            XStream xStream = XStreamCreator.create(MicroMchInput.class);
            String xml = xStream.toXML((Object)xwr);
            log.info("\u67e5\u8be2\u5c0f\u5fae\u6536\u6b3e\u4eba\u8d44\u6599[submchmanage?action=query] xml request:\n {}", new Object[]{xml});
            result = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/mch/submchmanage?action=query", o.getMch_id(), p12FilePath);
            log.info("\u67e5\u8be2\u5c0f\u5fae\u6536\u6b3e\u4eba\u8d44\u6599[submchmanage?action=query] xml response:\n {}", new Object[]{result});
        }
        catch (Exception e) {
            log.error("queryMicroMch error:{}", new Object[]{e.getMessage()});
        }
        return result;
    }

    public static UnifiedOrderOutput unifiedorder(UnifiedOrderInput data, String apiKey) {
        return WechatCore.unifiedorder(data, apiKey);
    }

    public static WechatRefundOutput refund(WechatRefundInput data, String apiKey, String p12FilePath) {
        return WechatCore.refund(data, apiKey, p12FilePath);
    }

    public static WechatReverseOutput reverse(WechatReverseInput data, String apiKey, String p12FilePath) {
        return WechatCore.reverse(data, apiKey, p12FilePath);
    }

    public static WechatPayOutput micropay(WechatPayInput input, String apiKey) {
        return WechatCore.micropay(input, apiKey);
    }

    public static OrderQueryOutput orderQuery(OrderQueryInput input, String apiKey) {
        return WechatCore.orderQuery(input, apiKey);
    }

    public static CloseOrderOutput closeOrder(CloseOrderInput input, String apiKey) {
        return WechatCore.closeOrder(input, apiKey);
    }
}

