/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import java.io.File;
import java.util.Hashtable;

public class ZxingUtil {
    static int qrcode_default_width = 250;
    static int qrcode_default_height = 250;
    static int barcode_default_width = 700;
    static int barcode_default_height = 200;
    private static final Log log = LogFactory.get();

    public static void barCode(String contents, String imgPath, int width, int height) {
        int codeWidth = 95;
        codeWidth = Math.max(codeWidth, width);
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(contents, BarcodeFormat.CODE_128, codeWidth, height, null);
            bitMatrix = ZxingUtil.deleteWhite(bitMatrix);
            MatrixToImageWriter.writeToFile((BitMatrix)bitMatrix, (String)"png", (File)new File(imgPath));
        }
        catch (Exception e) {
            log.error(e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
    }

    public static void qrCode(int width, int height, String content, String suffix, String imgPath) {
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
            bitMatrix = ZxingUtil.deleteWhite(bitMatrix);
            File outputFile = new File(imgPath);
            MatrixToImageWriter.writeToFile((BitMatrix)bitMatrix, (String)suffix, (File)outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void barCode(String contents, String imgPath) {
        ZxingUtil.barCode(contents, imgPath, barcode_default_width, barcode_default_height);
    }

    public static void qrCode(String content, String suffix, String imgPath) {
        ZxingUtil.qrCode(qrcode_default_width, qrcode_default_height, content, suffix, imgPath);
    }

    public static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public static void main(String[] args) {
        ZxingUtil.qrCode(250, 250, "18650002030j0803151618030", "png", "/zone/test.png");
        ZxingUtil.barCode("18650002030j0803151618030", "/zone/barcode.png", 700, 200);
    }
}

