/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation.iterator;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.KeyException;
import org.tikv.common.key.Key;
import org.tikv.common.operation.iterator.ScanIterator;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.protobuf.ByteString;

public class ConcreteScanIterator
extends ScanIterator {
    private final long version;
    private final Logger logger = LoggerFactory.getLogger(ConcreteScanIterator.class);

    public ConcreteScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, long version, int limit) {
        this(conf, builder, startKey, ByteString.EMPTY, version, limit);
    }

    public ConcreteScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, long version) {
        this(conf, builder, startKey, endKey, version, Integer.MAX_VALUE);
    }

    private ConcreteScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, long version, int limit) {
        super(conf, builder, startKey, endKey, limit, false);
        this.version = version;
    }

    @Override
    TiRegion loadCurrentRegionToCache() throws GrpcException {
        try (RegionStoreClient client = this.builder.build(this.startKey);){
            TiRegion region;
            client.setTimeout(this.conf.getScanTimeout());
            ConcreteBackOffer backOffer = ConcreteBackOffer.newScannerNextMaxBackOff();
            this.currentCache = client.scan(backOffer, this.startKey, this.version);
            TiRegion tiRegion = region = client.getRegion();
            return tiRegion;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteString resolveCurrentLock(Kvrpcpb.KvPair current) {
        this.logger.warn(String.format("resolve current key error %s", current.getError().toString()));
        Pair<TiRegion, TiStore> pair = this.builder.getRegionManager().getRegionStorePairByKey(current.getKey());
        TiRegion region = (TiRegion)pair.first;
        TiStore store = (TiStore)pair.second;
        ConcreteBackOffer backOffer = ConcreteBackOffer.newGetBackOff(this.builder.getRegionManager().getPDClient().getClusterId());
        try (RegionStoreClient client = this.builder.build(region, store);){
            ByteString byteString = client.get(backOffer, current.getKey(), this.version);
            return byteString;
        }
        catch (Exception e) {
            throw new KeyException(current.getError());
        }
    }

    @Override
    public boolean hasNext() {
        Kvrpcpb.KvPair current;
        do {
            current = this.getCurrent();
            if (!this.isCacheDrained() || !this.cacheLoadFails()) continue;
            this.endOfScan = true;
            return false;
        } while (this.currentCache != null && current == null);
        return !this.processingLastBatch || current == null || this.hasEndKey && Key.toRawKey(current.getKey()).compareTo(this.endKey) < 0;
    }

    @Override
    public Kvrpcpb.KvPair next() {
        --this.limit;
        Kvrpcpb.KvPair current = (Kvrpcpb.KvPair)this.currentCache.get(this.index++);
        Objects.requireNonNull(current, "current kv pair cannot be null");
        if (current.hasError()) {
            ByteString val = this.resolveCurrentLock(current);
            current = Kvrpcpb.KvPair.newBuilder().setKey(current.getKey()).setValue(val).build();
        }
        return current;
    }

    private boolean isCacheDrained() {
        return this.currentCache == null || this.limit <= 0 || this.index >= this.currentCache.size() || this.index == -1;
    }

    private Kvrpcpb.KvPair getCurrent() {
        if (this.isCacheDrained()) {
            return null;
        }
        return (Kvrpcpb.KvPair)this.currentCache.get(this.index);
    }
}

