/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.HostMapping;
import org.tikv.common.pd.PDUtils;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.common.collect.ImmutableList;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.netty.GrpcSslContexts;
import org.tikv.shade.io.grpc.netty.NettyChannelBuilder;
import org.tikv.shade.io.netty.handler.ssl.SslContext;
import org.tikv.shade.io.netty.handler.ssl.SslContextBuilder;

public class ChannelFactory
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFactory.class);
    private static final String PUB_KEY_INFRA = "PKIX";
    private final long connRecycleTime;
    private final int maxFrameSize;
    private final int keepaliveTime;
    private final int keepaliveTimeout;
    private final int idleTimeout;
    private final CertContext certContext;
    private final CertWatcher certWatcher;
    @VisibleForTesting
    public final ConcurrentHashMap<String, ManagedChannel> connPool = new ConcurrentHashMap();
    private final AtomicReference<SslContextBuilder> sslContextBuilder = new AtomicReference();
    private final ScheduledExecutorService recycler;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ChannelFactory(int maxFrameSize, int keepaliveTime, int keepaliveTimeout, int idleTimeout) {
        this.maxFrameSize = maxFrameSize;
        this.keepaliveTime = keepaliveTime;
        this.keepaliveTimeout = keepaliveTimeout;
        this.idleTimeout = idleTimeout;
        this.certWatcher = null;
        this.certContext = null;
        this.recycler = null;
        this.connRecycleTime = 0L;
    }

    public ChannelFactory(int maxFrameSize, int keepaliveTime, int keepaliveTimeout, int idleTimeout, long connRecycleTime, long certReloadInterval, String trustCertCollectionFilePath, String keyCertChainFilePath, String keyFilePath) {
        this.maxFrameSize = maxFrameSize;
        this.keepaliveTime = keepaliveTime;
        this.keepaliveTimeout = keepaliveTimeout;
        this.idleTimeout = idleTimeout;
        this.connRecycleTime = connRecycleTime;
        this.certContext = new OpenSslContext(trustCertCollectionFilePath, keyCertChainFilePath, keyFilePath);
        this.recycler = Executors.newSingleThreadScheduledExecutor();
        File trustCert = new File(trustCertCollectionFilePath);
        File keyCert = new File(keyCertChainFilePath);
        File key = new File(keyFilePath);
        if (certReloadInterval > 0L) {
            this.onCertChange();
            this.certWatcher = new CertWatcher(certReloadInterval, ImmutableList.of(trustCert, keyCert, key), this::onCertChange);
        } else {
            this.certWatcher = null;
        }
    }

    public ChannelFactory(int maxFrameSize, int keepaliveTime, int keepaliveTimeout, int idleTimeout, long connRecycleTime, long certReloadInterval, String jksKeyPath, String jksKeyPassword, String jksTrustPath, String jksTrustPassword) {
        this.maxFrameSize = maxFrameSize;
        this.keepaliveTime = keepaliveTime;
        this.keepaliveTimeout = keepaliveTimeout;
        this.idleTimeout = idleTimeout;
        this.connRecycleTime = connRecycleTime;
        this.certContext = new JksContext(jksKeyPath, jksKeyPassword, jksTrustPath, jksTrustPassword);
        this.recycler = Executors.newSingleThreadScheduledExecutor();
        File jksKey = new File(jksKeyPath);
        File jksTrust = new File(jksTrustPath);
        if (certReloadInterval > 0L) {
            this.onCertChange();
            this.certWatcher = new CertWatcher(certReloadInterval, ImmutableList.of(jksKey, jksTrust), this::onCertChange);
        } else {
            this.certWatcher = null;
        }
    }

    private void onCertChange() {
        try {
            SslContextBuilder newBuilder = this.certContext.createSslContextBuilder();
            this.lock.writeLock().lock();
            this.sslContextBuilder.set(newBuilder);
            ArrayList<ManagedChannel> pending = new ArrayList<ManagedChannel>(this.connPool.values());
            this.recycler.schedule(() -> this.cleanExpiredConn(pending), this.connRecycleTime, TimeUnit.SECONDS);
            this.connPool.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedChannel getChannel(String address, HostMapping mapping) {
        if (this.certContext != null) {
            try {
                this.lock.readLock().lock();
                ManagedChannel managedChannel = this.connPool.computeIfAbsent(address, key -> this.createChannel(this.sslContextBuilder.get(), address, mapping));
                return managedChannel;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return this.connPool.computeIfAbsent(address, key -> this.createChannel(null, address, mapping));
    }

    private ManagedChannel createChannel(SslContextBuilder sslContextBuilder, String address, HostMapping mapping) {
        SslContext sslContext;
        URI mapped;
        URI uri;
        try {
            uri = PDUtils.addrToUri(address);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to form address " + address, e);
        }
        try {
            mapped = mapping.getMappedURI(uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to get mapped address " + uri, e);
        }
        NettyChannelBuilder builder = (NettyChannelBuilder)NettyChannelBuilder.forAddress(mapped.getHost(), mapped.getPort()).maxInboundMessageSize(this.maxFrameSize).keepAliveTime(this.keepaliveTime, TimeUnit.SECONDS).keepAliveTimeout(this.keepaliveTimeout, TimeUnit.SECONDS).keepAliveWithoutCalls(true).idleTimeout(this.idleTimeout, TimeUnit.SECONDS);
        if (sslContextBuilder == null) {
            return builder.usePlaintext().build();
        }
        try {
            sslContext = sslContextBuilder.build();
        }
        catch (SSLException e) {
            logger.error("create ssl context failed!", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return builder.sslContext(sslContext).build();
    }

    private void cleanExpiredConn(List<ManagedChannel> pending) {
        for (ManagedChannel channel : pending) {
            logger.info("cleaning expire channels");
            channel.shutdownNow();
            while (!channel.isShutdown()) {
                try {
                    channel.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    logger.warn("recycle channels timeout:", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() {
        for (ManagedChannel ch : this.connPool.values()) {
            ch.shutdown();
        }
        this.connPool.clear();
        if (this.recycler != null) {
            this.recycler.shutdown();
        }
        if (this.certWatcher != null) {
            this.certWatcher.close();
        }
    }

    @VisibleForTesting
    public static class OpenSslContext
    extends CertContext {
        private final String trustPath;
        private final String chainPath;
        private final String keyPath;

        public OpenSslContext(String trustPath, String chainPath, String keyPath) {
            this.trustPath = trustPath;
            this.chainPath = chainPath;
            this.keyPath = keyPath;
        }

        @Override
        public SslContextBuilder createSslContextBuilder() {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            try {
                if (this.trustPath != null) {
                    builder.trustManager(new File(this.trustPath));
                }
                if (this.chainPath != null && this.keyPath != null) {
                    builder.keyManager(new File(this.chainPath), new File(this.keyPath));
                }
            }
            catch (Exception e) {
                logger.error("Failed to create ssl context builder", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            return builder;
        }
    }

    public static class JksContext
    extends CertContext {
        private final String keyPath;
        private final String keyPassword;
        private final String trustPath;
        private final String trustPassword;

        public JksContext(String keyPath, String keyPassword, String trustPath, String trustPassword) {
            this.keyPath = keyPath;
            this.keyPassword = keyPassword;
            this.trustPath = trustPath;
            this.trustPassword = trustPassword;
        }

        @Override
        public SslContextBuilder createSslContextBuilder() {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            try {
                if (this.keyPath != null && this.keyPassword != null) {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(new FileInputStream(this.keyPath), this.keyPassword.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, this.keyPassword.toCharArray());
                    builder.keyManager(keyManagerFactory);
                }
                if (this.trustPath != null && this.trustPassword != null) {
                    KeyStore trustStore = KeyStore.getInstance("JKS");
                    trustStore.load(new FileInputStream(this.trustPath), this.trustPassword.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(ChannelFactory.PUB_KEY_INFRA);
                    trustManagerFactory.init(trustStore);
                    builder.trustManager(trustManagerFactory);
                }
            }
            catch (Exception e) {
                logger.error("JKS SSL context builder failed!", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            return builder;
        }
    }

    @VisibleForTesting
    public static abstract class CertContext {
        public abstract SslContextBuilder createSslContextBuilder();
    }

    @VisibleForTesting
    public static class CertWatcher
    implements AutoCloseable {
        private static final Logger logger = LoggerFactory.getLogger(CertWatcher.class);
        private final List<File> targets;
        private final List<Long> lastReload = new ArrayList<Long>();
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        private final Runnable onChange;

        public CertWatcher(long pollInterval, List<File> targets, Runnable onChange) {
            this.targets = targets;
            this.onChange = onChange;
            for (File ignored : targets) {
                this.lastReload.add(0L);
            }
            this.executorService.scheduleAtFixedRate(this::tryReload, pollInterval, pollInterval, TimeUnit.SECONDS);
        }

        private void tryReload() {
            try {
                if (this.needReload()) {
                    this.onChange.run();
                }
            }
            catch (Exception e) {
                logger.error("Failed to reload cert!", (Throwable)e);
            }
        }

        private boolean needReload() {
            boolean needReload = false;
            for (int i = 0; i < this.targets.size(); ++i) {
                try {
                    long lastModified = this.targets.get(i).lastModified();
                    if (lastModified == this.lastReload.get(i)) continue;
                    this.lastReload.set(i, lastModified);
                    logger.warn("detected ssl context changes: {}", (Object)this.targets.get(i));
                    needReload = true;
                    continue;
                }
                catch (Exception e) {
                    logger.error("fail to check the status of ssl context files", (Throwable)e);
                }
            }
            return needReload;
        }

        @Override
        public void close() {
            this.executorService.shutdown();
        }
    }
}

