/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.log.SlowLog;
import org.tikv.common.log.SlowLogEmptyImpl;
import org.tikv.common.log.SlowLogSpan;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.HistogramUtils;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.io.prometheus.client.Histogram;

public class ConcreteBackOffer
implements BackOffer {
    private static final Logger logger = LoggerFactory.getLogger(ConcreteBackOffer.class);
    private final int maxSleep;
    private final Long clusterId;
    @VisibleForTesting
    public final Map<BackOffFunction.BackOffFuncType, BackOffFunction> backOffFunctionMap;
    @VisibleForTesting
    public final List<Exception> errors;
    private int totalSleep;
    private final long deadline;
    private final SlowLog slowLog;
    public static final Histogram BACKOFF_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_backoff_duration")).help("backoff duration.")).labelNames("type", "cluster")).register();

    private ConcreteBackOffer(int maxSleep, long deadline, SlowLog slowLog, long clusterId) {
        Preconditions.checkArgument(maxSleep == 0 || deadline == 0L, "Max sleep time should be 0 or Deadline should be 0.");
        Preconditions.checkArgument(maxSleep >= 0, "Max sleep time cannot be less than 0.");
        Preconditions.checkArgument(deadline >= 0L, "Deadline cannot be less than 0.");
        this.clusterId = clusterId;
        this.maxSleep = maxSleep;
        this.errors = Collections.synchronizedList(new ArrayList());
        this.backOffFunctionMap = new ConcurrentHashMap<BackOffFunction.BackOffFuncType, BackOffFunction>();
        this.deadline = deadline;
        this.slowLog = slowLog;
    }

    private ConcreteBackOffer(ConcreteBackOffer source) {
        this.clusterId = source.clusterId;
        this.maxSleep = source.maxSleep;
        this.totalSleep = source.totalSleep;
        this.errors = source.errors;
        this.backOffFunctionMap = source.backOffFunctionMap;
        this.deadline = source.deadline;
        this.slowLog = source.slowLog;
    }

    public static ConcreteBackOffer newDeadlineBackOff(int timeoutInMs, SlowLog slowLog, long clusterId) {
        long deadline = System.currentTimeMillis() + (long)timeoutInMs;
        return new ConcreteBackOffer(0, deadline, slowLog, clusterId);
    }

    public static ConcreteBackOffer newDeadlineBackOff(int timeoutInMs, SlowLog slowLog) {
        return ConcreteBackOffer.newDeadlineBackOff(timeoutInMs, slowLog, 0L);
    }

    public static ConcreteBackOffer newCustomBackOff(int maxSleep, long clusterId) {
        return new ConcreteBackOffer(maxSleep, 0L, SlowLogEmptyImpl.INSTANCE, clusterId);
    }

    public static ConcreteBackOffer newCustomBackOff(int maxSleep) {
        return ConcreteBackOffer.newCustomBackOff(maxSleep, 0L);
    }

    public static ConcreteBackOffer newScannerNextMaxBackOff() {
        return new ConcreteBackOffer(40000, 0L, SlowLogEmptyImpl.INSTANCE, 0L);
    }

    public static ConcreteBackOffer newBatchGetMaxBackOff() {
        return new ConcreteBackOffer(40000, 0L, SlowLogEmptyImpl.INSTANCE, 0L);
    }

    public static ConcreteBackOffer newCopNextMaxBackOff() {
        return ConcreteBackOffer.newCopNextMaxBackOff(0L);
    }

    public static ConcreteBackOffer newCopNextMaxBackOff(long clusterId) {
        return new ConcreteBackOffer(40000, 0L, SlowLogEmptyImpl.INSTANCE, clusterId);
    }

    public static ConcreteBackOffer newGetBackOff(long clusterId) {
        return new ConcreteBackOffer(40000, 0L, SlowLogEmptyImpl.INSTANCE, clusterId);
    }

    public static ConcreteBackOffer newRawKVBackOff(long clusterId) {
        return new ConcreteBackOffer(20000, 0L, SlowLogEmptyImpl.INSTANCE, clusterId);
    }

    public static ConcreteBackOffer newRawKVBackOff() {
        return ConcreteBackOffer.newRawKVBackOff(0L);
    }

    public static ConcreteBackOffer newTsoBackOff(long clusterId) {
        return new ConcreteBackOffer(5000, 0L, SlowLogEmptyImpl.INSTANCE, clusterId);
    }

    public static ConcreteBackOffer create(BackOffer source) {
        return new ConcreteBackOffer((ConcreteBackOffer)source);
    }

    private BackOffFunction createBackOffFunc(BackOffFunction.BackOffFuncType funcType) {
        BackOffFunction backOffFunction = null;
        switch (funcType) {
            case BoUpdateLeader: {
                backOffFunction = BackOffFunction.create(1, 10, BackOffer.BackOffStrategy.NoJitter);
                break;
            }
            case BoTxnLockFast: {
                backOffFunction = BackOffFunction.create(100, 3000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoServerBusy: {
                backOffFunction = BackOffFunction.create(2000, 10000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoRegionMiss: {
                backOffFunction = BackOffFunction.create(TiConfiguration.getInt("tikv.bo_region_miss_base_in_ms"), 500, BackOffer.BackOffStrategy.NoJitter);
                break;
            }
            case BoTxnLock: {
                backOffFunction = BackOffFunction.create(200, 3000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoPDRPC: {
                backOffFunction = BackOffFunction.create(100, 600, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoTiKVRPC: {
                backOffFunction = BackOffFunction.create(10, 400, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoTxnNotFound: {
                backOffFunction = BackOffFunction.create(2, 500, BackOffer.BackOffStrategy.NoJitter);
                break;
            }
            case BoCheckTimeout: {
                backOffFunction = BackOffFunction.create(0, 0, BackOffer.BackOffStrategy.NoJitter);
                break;
            }
            case BoCheckHealth: {
                backOffFunction = BackOffFunction.create(100, 600, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoTsoBatchUsedUp: {
                backOffFunction = BackOffFunction.create(TiConfiguration.getInt("tikv.bo_region_miss_base_in_ms"), 500, BackOffer.BackOffStrategy.NoJitter);
            }
        }
        return backOffFunction;
    }

    @Override
    public void doBackOff(BackOffFunction.BackOffFuncType funcType, Exception err) {
        this.doBackOffWithMaxSleep(funcType, -1L, err);
    }

    @Override
    public void checkTimeout() {
        if (!this.canRetryAfterSleep(BackOffFunction.BackOffFuncType.BoCheckTimeout)) {
            this.logThrowError(new TiKVException("Request Timeout"));
        }
    }

    @Override
    public boolean canRetryAfterSleep(BackOffFunction.BackOffFuncType funcType) {
        return this.canRetryAfterSleep(funcType, -1L);
    }

    public boolean canRetryAfterSleep(BackOffFunction.BackOffFuncType funcType, long maxSleepMs) {
        long currentMs;
        String[] labels = new String[]{funcType.name(), this.clusterId.toString()};
        Histogram.Timer backOffTimer = ((Histogram.Child)BACKOFF_DURATION.labels(labels)).startTimer();
        SlowLogSpan slowLogSpan = this.getSlowLog().start("backoff");
        slowLogSpan.addProperty("type", funcType.name());
        BackOffFunction backOffFunction = this.backOffFunctionMap.computeIfAbsent(funcType, this::createBackOffFunc);
        long sleep = backOffFunction.getSleepMs(maxSleepMs);
        this.totalSleep = (int)((long)this.totalSleep + sleep);
        if (this.deadline > 0L && (currentMs = System.currentTimeMillis()) + sleep >= this.deadline) {
            logger.warn(String.format("Deadline %d is exceeded, errors:", this.deadline));
            slowLogSpan.end();
            backOffTimer.observeDuration();
            return false;
        }
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException e) {
            throw new GrpcException(e);
        }
        finally {
            slowLogSpan.end();
            backOffTimer.observeDuration();
        }
        if (this.maxSleep > 0 && this.totalSleep >= this.maxSleep) {
            logger.warn(String.format("BackOffer.maxSleep %dms is exceeded, errors:", this.maxSleep));
            return false;
        }
        return true;
    }

    @Override
    public void doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType funcType, long maxSleepMs, Exception err) {
        logger.debug(String.format("%s, retry later(totalSleep %dms, maxSleep %dms)", err.getMessage(), this.totalSleep, this.maxSleep));
        this.errors.add(err);
        if (!this.canRetryAfterSleep(funcType, maxSleepMs)) {
            this.logThrowError(err);
        }
    }

    private void logThrowError(Exception err) {
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < this.errors.size(); ++i) {
            Exception curErr = this.errors.get(i);
            if (!logger.isDebugEnabled() && i < this.errors.size() - 3) continue;
            errMsg.append("\n").append(i).append(".").append(curErr.toString());
        }
        logger.warn(errMsg.toString());
        throw new GrpcException("retry is exhausted.", err);
    }

    @Override
    public SlowLog getSlowLog() {
        return this.slowLog;
    }

    @Override
    public Long getClusterId() {
        return this.clusterId;
    }
}

