/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.Iterator;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJVisibilityKind;
import org.umlg.java.metamodel.generated.OJInterfaceGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;

public class OJInterface
extends OJInterfaceGEN {
    public OJInterface() {
        this.setVisibility(OJVisibilityKind.PUBLIC);
    }

    @Override
    public void calcImports() {
        super.calcImports();
        for (OJPathName intf : this.getSuperInterfaces()) {
            this.addToImports(intf);
        }
    }

    @Override
    public String toJavaString() {
        this.calcImports();
        StringBuilder classInfo = new StringBuilder();
        classInfo.append(this.getMyPackage().toJavaString());
        classInfo.append("\n");
        classInfo.append((CharSequence)this.imports());
        classInfo.append("\n");
        if (!this.getComment().equals("")) {
            this.addJavaDocComment(classInfo);
        }
        if (this.isAbstract()) {
            classInfo.append("abstract ");
        }
        classInfo.append(this.visToJava(this) + " ");
        classInfo.append("interface " + this.getName());
        classInfo.append((CharSequence)this.superInterfaces());
        classInfo.append(" {\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.operations(), 1));
        classInfo.append("\n");
        classInfo.append("}");
        return classInfo.toString();
    }

    private StringBuilder superInterfaces() {
        StringBuilder result = new StringBuilder();
        if (this.getSuperInterfaces().size() > 0) {
            Iterator<OJPathName> it = this.getSuperInterfaces().iterator();
            boolean first = true;
            while (it.hasNext()) {
                OJPathName elem = it.next();
                if (first) {
                    result.append(" extends ");
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(elem.getLast());
            }
        }
        return result;
    }

    public OJInterface getDeepCopy(OJPackage owner) {
        OJInterface copy = new OJInterface();
        copy.setMyPackage(owner);
        this.copyDeepInfoInto(copy);
        return copy;
    }

    protected void copyDeepInfoInto(OJInterface copy) {
        super.copyDeepInfoInto(copy);
        for (OJPathName elem : new ArrayList<OJPathName>(this.getSuperInterfaces())) {
            copy.addToSuperInterfaces(elem.getDeepCopy());
        }
    }
}

