/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.umlg.java.metamodel.OJBlock;
import org.umlg.java.metamodel.OJInterface;
import org.umlg.java.metamodel.OJParameter;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJVisibilityKind;
import org.umlg.java.metamodel.generated.OJOperationGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;

public class OJOperation
extends OJOperationGEN {
    public OJOperation() {
        this.setBody(new OJBlock());
        this.setVisibility(OJVisibilityKind.PUBLIC);
        this.setReturnType(new OJPathName("void"));
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("(");
        for (OJParameter p : this.getParameters()) {
            sb.append(p.getType().getLast());
            sb.append(",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    public void addParam(String name, OJPathName type) {
        OJParameter param = new OJParameter();
        param.setName(name);
        param.setType(type);
        this.addToParameters(param);
    }

    public void addParam(String name, String type) {
        OJPathName path = new OJPathName(type);
        this.addParam(name, path);
    }

    public void addToThrows(String type) {
        OJPathName path = new OJPathName(type);
        this.addToThrows(path);
    }

    @Override
    public String toJavaString() {
        StringBuilder result = new StringBuilder();
        if (!this.getComment().equals("")) {
            this.addJavaDocComment(result);
        }
        if (this.getNeedsSuppress()) {
            result.append("@SuppressWarnings(\"unchecked\")\n");
        }
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        result.append(this.visToJava(this) + " ");
        if (this.getGenericTypeParam() != null) {
            result.append("<" + this.getGenericTypeParam().getLast() + "> ");
        }
        result.append(this.getReturnType().getCollectionTypeName());
        result.append(" " + this.getName());
        result.append("(" + this.paramsToJava(this) + ")");
        if (!this.getThrows().isEmpty()) {
            result.append(" throws " + this.exceptionsToJava(this));
        }
        if (this.getOwner() instanceof OJInterface || this.isAbstract()) {
            result.append(";\n");
        } else {
            result.append(" {\n");
            StringBuilder bodyStr = new StringBuilder();
            String actualBody = this.getBody().toJavaString();
            bodyStr.append(actualBody);
            result.append((CharSequence)JavaStringHelpers.indent(bodyStr, 1));
            if (result.charAt(result.length() - 1) == '\n') {
                result.deleteCharAt(result.length() - 1);
            }
            result.append("\n}\n");
        }
        return result.toString();
    }

    protected void addJavaDocComment(StringBuilder result) {
        String comment = this.getComment();
        comment = JavaStringHelpers.replaceAllSubstrings(comment, "\n", "\n * ");
        result.append("/**\n * " + comment);
        boolean first = true;
        for (OJParameter par : this.getParameters()) {
            String paramStr = "@param " + par.getName() + " " + par.getComment();
            if (first) {
                result.append("\n * ");
                first = false;
            }
            result.append("\n * " + paramStr);
        }
        result.append("\n */\n");
    }

    protected StringBuilder paramsToJava(OJOperation op) {
        StringBuilder result = new StringBuilder();
        Iterator<OJParameter> it = op.getParameters().iterator();
        boolean first = true;
        while (it.hasNext()) {
            OJParameter elem = it.next();
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(elem.toJavaString());
        }
        return result;
    }

    protected StringBuilder exceptionsToJava(OJOperation op) {
        StringBuilder result = new StringBuilder();
        Iterator<OJPathName> it = op.getThrows().iterator();
        boolean first = true;
        while (it.hasNext()) {
            OJPathName elem = it.next();
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(elem.getLast());
        }
        return result;
    }

    public static StringBuilder paramsToActuals(OJOperation op) {
        StringBuilder result = new StringBuilder();
        Iterator<OJParameter> it = op.getParameters().iterator();
        boolean first = true;
        while (it.hasNext()) {
            OJParameter elem = it.next();
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(elem.getName());
        }
        return result;
    }

    public OJOperation getCopy() {
        OJOperation result = new OJOperation();
        this.copyValues(result);
        return result;
    }

    public OJOperation getDeepCopy() {
        OJOperation result = new OJOperation();
        this.copyValuesDeep(result);
        return result;
    }

    protected void copyValuesDeep(OJOperation result) {
        result.setComment(this.getComment());
        result.setBody(this.getBody().getDeepCopy());
        result.setReturnType(this.getReturnType().getDeepCopy());
        result.setFinal(this.isFinal());
        result.setStatic(this.isStatic());
        result.setVolatile(this.isVolatile());
        result.setName(this.getName());
        result.setAbstract(this.isAbstract());
        for (OJParameter ojParameter : this.getParameters()) {
            result.addToParameters(ojParameter.getDeepCopy());
        }
        result.setVisibility(this.getVisibility());
    }

    protected void copyValues(OJOperation result) {
        result.setComment(this.getComment());
        result.setBody(this.getBody().getCopy());
        result.setReturnType(this.getReturnType());
        result.setFinal(this.isFinal());
        result.setStatic(this.isStatic());
        result.setVolatile(this.isVolatile());
        result.setName(this.getName());
        ArrayList<OJParameter> params = new ArrayList<OJParameter>(this.getParameters());
        result.setParameters(params);
        result.setVisibility(this.getVisibility());
    }

    public boolean isEqual(String name, List types) {
        boolean result = false;
        if (this.getName().equals(name)) {
            List<OJParameter> myPars = this.getParameters();
            if (myPars.size() == 0 && types.size() == 0) {
                result = true;
            } else if (myPars.size() == types.size()) {
                Iterator<OJParameter> parsIt = myPars.iterator();
                Iterator typesIt = types.iterator();
                boolean loopResult = true;
                while (parsIt.hasNext()) {
                    OJParameter par = parsIt.next();
                    OJPathName type = (OJPathName)typesIt.next();
                    if (par.getType().equals(type)) continue;
                    loopResult = false;
                }
                result = loopResult;
            }
        }
        return result;
    }

    @Override
    public List<OJPathName> getParamTypes() {
        ArrayList<OJPathName> result = new ArrayList<OJPathName>();
        for (OJParameter par : this.getParameters()) {
            result.add(par.getType());
        }
        return result;
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        this.getReturnType().renameAll(renamePathNames, newName);
        for (OJParameter parameter : this.getParameters()) {
            parameter.renameAll(renamePathNames, newName);
        }
        this.getBody().renameAll(renamePathNames, newName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof OJOperation) {
            OJOperation o = (OJOperation)other;
            List<OJPathName> oParamTypes = o.getParamTypes();
            if (o.getOwner().equals(this.getOwner()) && o.getName().equals(this.getName())) {
                return this.paramsEquals(oParamTypes);
            }
        }
        return false;
    }

    public boolean paramsEquals(List<OJPathName> oParamTypes) {
        List<OJPathName> paramTypes = this.getParamTypes();
        boolean b = true;
        if (oParamTypes.size() == paramTypes.size()) {
            for (int i = 0; i < paramTypes.size(); ++i) {
                if (paramTypes.get(i).equals(oParamTypes.get(i))) continue;
                b = false;
                break;
            }
        } else {
            b = false;
        }
        return b;
    }
}

