/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.umlg.java.metamodel.OJClass;
import org.umlg.java.metamodel.OJClassifier;
import org.umlg.java.metamodel.OJInterface;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.OJAnnotatedPackageInfo;
import org.umlg.java.metamodel.generated.OJPackageGEN;

public class OJPackage
extends OJPackageGEN {
    private List<OJAnnotatedPackageInfo> packageInfos = new ArrayList<OJAnnotatedPackageInfo>();

    public OJPackage() {
    }

    public OJPackage(String name, OJPackage parent) {
        this(name);
        this.setParent(parent);
    }

    @Override
    public void finalize() {
        super.finalize();
    }

    public OJPackage(String name) {
        this.setName(name);
    }

    public void addToPackageInfo(OJAnnotatedPackageInfo pk) {
        this.packageInfos.add(pk);
        pk.setMyPackage(this);
    }

    @Override
    public String toJavaString() {
        StringBuilder packInfo = new StringBuilder();
        if (!this.getPathName().toJavaString().equals("")) {
            packInfo.append("package " + this.getPathName().toJavaString() + ";");
        }
        return packInfo.toString();
    }

    @Override
    public String toString() {
        return this.getPathName().toString();
    }

    @Override
    public OJPathName getPathName() {
        OJPathName result = null;
        result = this.getParent() != null ? this.getParent().getPathName().append(this.getName()) : new OJPathName(this.getName());
        return result;
    }

    public OJClassifier findIntfOrCls(OJPathName path) {
        OJClassifier result = null;
        result = this.findInterface(path);
        if (result == null) {
            result = this.findClass(path);
        }
        return result;
    }

    public OJInterface findInterface(OJPathName path) {
        if (path == null) {
            return null;
        }
        if (path.isSingleName()) {
            return this.findLocalInterface(path.getLast());
        }
        OJPackage first = this.findLocalPackage(path.getFirst());
        if (first != null) {
            return first.findInterface(path.getTail());
        }
        return null;
    }

    @Override
    public OJPackage findPackage(OJPathName path) {
        if (path == null) {
            return null;
        }
        if (path.isSingleName()) {
            return this.findLocalPackage(path.getLast());
        }
        OJPackage first = this.findLocalPackage(path.getFirst());
        if (first != null) {
            return first.findPackage(path.getTail());
        }
        return null;
    }

    private OJInterface findLocalInterface(String string) {
        OJInterface result = null;
        for (OJInterface elem : this.getInterfaces()) {
            if (!elem.getName().equals(string)) continue;
            result = elem;
        }
        return result;
    }

    @Override
    public OJClass findClass(OJPathName path) {
        if (path == null) {
            return null;
        }
        if (path.isSingleName()) {
            return this.findLocalClass(path.getLast());
        }
        OJPackage first = this.findLocalPackage(path.getFirst());
        if (first != null) {
            return first.findClass(path.getTail());
        }
        return null;
    }

    @Override
    protected OJClass findLocalClass(String string) {
        OJClass result = null;
        for (OJClass elem : this.getClasses()) {
            if (!elem.getName().equals(string)) continue;
            result = elem;
        }
        return result;
    }

    @Override
    protected OJPackage findLocalPackage(String string) {
        OJPackage result = null;
        for (OJPackage elem : this.getSubpackages()) {
            if (!elem.getName().equals(string)) continue;
            result = elem;
        }
        return result;
    }

    public OJPackage getDeepCopy(OJPackage owner) {
        OJPackage copy = new OJPackage();
        this.copyDeepInfoInto(owner, copy);
        return copy;
    }

    protected void copyDeepInfoInto(OJPackage owner, OJPackage copy) {
        super.copyDeepInfoInto(copy);
        for (OJClass elem : new ArrayList<OJClass>(this.getClasses())) {
            copy.addToClasses(elem.getDeepCopy(copy));
        }
        for (OJInterface elem : new ArrayList<OJInterface>(this.getInterfaces())) {
            copy.addToInterfaces(elem);
        }
        if (owner != null) {
            copy.setParent(owner);
        }
        for (OJPackage elem : new ArrayList<OJPackage>(this.getSubpackages())) {
            copy.addToSubpackages(elem.getDeepCopy(owner));
        }
    }

    @Override
    public void renameAll(Set<OJPathName> match, String suffix) {
        for (OJClass ojClass : this.getClasses()) {
            ojClass.renameAll(match, suffix);
        }
        for (OJAnnotatedPackageInfo pi : this.packageInfos) {
            pi.renameAll(match, suffix);
        }
        Set<OJPackage> subpackages = this.getSubpackages();
        for (OJPackage p : subpackages) {
            p.renameAll(match, suffix);
        }
    }

    public void release() {
        this.setParent(null);
        this.packageInfos.clear();
        for (OJClass ojClass : new ArrayList<OJClass>(this.getClasses())) {
            ojClass.release();
        }
        for (OJPackage p : new ArrayList<OJPackage>(this.getSubpackages())) {
            p.release();
        }
    }
}

