/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.umlg.java.metamodel.OJInterface;
import org.umlg.java.metamodel.OJOperation;
import org.umlg.java.metamodel.OJParameter;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.AnnotationHelper;
import org.umlg.java.metamodel.annotation.OJAnnotatedElement;
import org.umlg.java.metamodel.annotation.OJAnnotatedField;
import org.umlg.java.metamodel.annotation.OJAnnotatedInterface;
import org.umlg.java.metamodel.annotation.OJAnnotationValue;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJAnnotatedOperation
extends OJOperation
implements OJAnnotatedElement {
    Map<OJPathName, OJAnnotationValue> f_annotations = new TreeMap<OJPathName, OJAnnotationValue>();
    private OJAnnotatedField resultVariable;
    private boolean interfaceDefault;
    private boolean isSynchronized = false;

    public OJAnnotatedOperation(String string, String returnPathName) {
        this(string);
        this.setReturnType(new OJPathName(returnPathName));
    }

    public OJAnnotatedOperation(String string, OJPathName returnPathName) {
        this(string);
        this.setReturnType(returnPathName);
    }

    public OJAnnotatedOperation(String string) {
        this.setName(string);
    }

    public boolean isInterfaceDefault() {
        return this.interfaceDefault;
    }

    public void setInterfaceDefault(boolean interfaceDefault) {
        this.interfaceDefault = interfaceDefault;
    }

    @Override
    public OJAnnotatedOperation getCopy() {
        OJAnnotatedOperation oper = new OJAnnotatedOperation(this.getName());
        super.copyValues(oper);
        oper.removeAllFromParameters();
        for (OJParameter f : this.getParameters()) {
            oper.addToParameters((OJParameter)f.getCopy());
        }
        for (OJAnnotationValue v : this.getAnnotations()) {
            oper.addAnnotationIfNew(v.getCopy());
        }
        return oper;
    }

    @Override
    public boolean addAnnotationIfNew(OJAnnotationValue value) {
        if (this.f_annotations.containsKey(value.getType())) {
            return false;
        }
        this.putAnnotation(value);
        return true;
    }

    @Override
    public OJAnnotationValue removeAnnotation(OJPathName type) {
        return this.f_annotations.remove(type);
    }

    @Override
    public Collection<OJAnnotationValue> getAnnotations() {
        return this.f_annotations.values();
    }

    @Override
    public OJAnnotationValue putAnnotation(OJAnnotationValue value) {
        return this.f_annotations.put(value.getType(), value);
    }

    @Override
    public String toJavaString() {
        StringBuilder result = new StringBuilder();
        if (!this.getComment().equals("")) {
            this.addJavaDocComment(result);
        }
        if (this.getNeedsSuppress()) {
            result.append("@SuppressWarnings(\"unchecked\")\n");
        }
        if (this.getAnnotations().size() > 0) {
            result.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getAnnotations(), "\n"), 0));
            result.append("\n");
        }
        if (this.isSynchronized()) {
            result.append("synchronized ");
        }
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        if (this.isInterfaceDefault()) {
            result.append("default ");
        }
        result.append(this.visToJava(this) + " ");
        if (this.getGenericTypeParam() != null) {
            result.append("<" + this.getGenericTypeParam().getLast() + "> ");
        }
        result.append(this.getReturnType().getCollectionTypeName());
        result.append(" " + this.getName());
        result.append("(" + this.paramsToJava(this) + ")");
        if (!this.getThrows().isEmpty()) {
            result.append(" throws " + this.exceptionsToJava(this));
        }
        if (this.getOwner() instanceof OJAnnotatedInterface && !this.isStatic() && !this.isInterfaceDefault() || this.getOwner() instanceof OJInterface || this.isAbstract()) {
            result.append(";\n");
        } else {
            result.append(" {\n");
            StringBuilder bodyStr = new StringBuilder();
            if (this.resultVariable != null) {
                if (this.resultVariable.getType() == null) {
                    this.resultVariable.setType(this.getReturnType());
                }
                bodyStr.append(this.resultVariable.toJavaString());
                bodyStr.append("\n");
            }
            bodyStr.append(this.getBody().toJavaString());
            if (this.resultVariable != null) {
                bodyStr.append("\nreturn result;");
            }
            result.append((CharSequence)JavaStringHelpers.indent(bodyStr, 1));
            if (result.charAt(result.length() - 1) == '\n') {
                result.deleteCharAt(result.length() - 1);
            }
            result.append("\n}\n");
        }
        return result.toString();
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String suffix) {
        super.renameAll(renamePathNames, suffix);
        for (OJAnnotationValue annotation : this.getAnnotations()) {
            annotation.renameAll(renamePathNames, suffix);
        }
        if (this.resultVariable != null) {
            this.resultVariable.renameAll(renamePathNames, suffix);
        }
    }

    @Override
    public OJOperation getDeepCopy() {
        OJAnnotatedOperation result = new OJAnnotatedOperation(this.getName());
        this.copyValuesDeep(result);
        return result;
    }

    @Override
    public OJAnnotationValue findAnnotation(OJPathName ojPathName) {
        return AnnotationHelper.getAnnotation(this, ojPathName);
    }

    public void initializeResultVariable(String initialValue) {
        if (initialValue == null) {
            this.resultVariable = null;
        } else {
            this.resultVariable = new OJAnnotatedField("result", this.getReturnType());
            this.resultVariable.setInitExp(initialValue);
        }
    }

    public OJAnnotatedField getResultVariable() {
        return this.resultVariable;
    }

    public OJParameter findParameter(String fieldname) {
        for (OJParameter p : this.getParameters()) {
            if (!p.getName().equals(fieldname)) continue;
            return p;
        }
        return null;
    }

    public void setSynchronized() {
        this.isSynchronized = true;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }
}

