/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.umlg.java.metamodel.OJElement;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.OJAnnotationValue;
import org.umlg.java.metamodel.annotation.OJEnumValue;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;

public abstract class OJMetaValue
extends OJElement {
    boolean importType = true;
    protected List<Object> values = new ArrayList<Object>();

    public boolean isImportType() {
        return this.importType;
    }

    public void setImportType(boolean importType) {
        this.importType = importType;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public OJMetaValue() {
    }

    public OJMetaValue(OJPathName value) {
        this.addValue(value);
    }

    public OJMetaValue(OJAnnotationValue value) {
        this.addValue(value);
    }

    public OJMetaValue(Boolean value) {
        this.addValue(value);
    }

    public OJMetaValue(String value) {
        this.addValue(value);
    }

    public OJMetaValue(Number value) {
        this.addValue(value);
    }

    public OJMetaValue(OJEnumValue value) {
        this.addValue(value);
    }

    public void addTypesUsed(Set<OJPathName> s) {
        for (Object o : this.values) {
            if (o instanceof OJAnnotationValue) {
                ((OJAnnotationValue)o).addTypesUsed(s);
                continue;
            }
            if (o instanceof OJPathName) {
                s.add((OJPathName)o);
                continue;
            }
            if (!(o instanceof OJEnumValue)) continue;
        }
    }

    public boolean hasValues() {
        return this.values.size() > 0;
    }

    public void addAnnotationValue(OJAnnotationValue value) {
        this.addValue(value);
    }

    private void addValue(Object v) {
        this.values.add(v);
    }

    public void addEnumValue(OJEnumValue value) {
        this.addValue(value);
    }

    public void addBooleanValue(Boolean value) {
        this.addValue(value);
    }

    public void addStringValue(String value) {
        this.addValue(value);
    }

    public void addNumberValue(Number value) {
        this.addValue(value);
    }

    public void addClassValue(OJPathName ojPathName) {
        this.addValue(ojPathName);
    }

    protected String toJavaValueExpression() {
        String expression;
        if (this.values.size() == 1) {
            expression = OJMetaValue.toLiteralString(this.values.get(0));
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            Iterator<Object> values = this.values.iterator();
            while (values.hasNext()) {
                Object element = values.next();
                sb.append(OJMetaValue.toLiteralString(element));
                if (!values.hasNext()) continue;
                sb.append(',');
            }
            sb.append("}");
            expression = sb.toString();
        }
        return JavaStringHelpers.indent(expression, 1);
    }

    public void copyInfoInto(OJMetaValue copy) {
        super.copyInfoInto(copy);
        for (Object o : this.values) {
            copy.values.add(o);
        }
    }

    public void copyDeepInfoInto(OJMetaValue copy) {
        super.copyInfoInto(copy);
        copy.importType = this.importType;
        for (Object o : this.values) {
            if (o instanceof OJPathName) {
                copy.values.add(((OJPathName)o).getDeepCopy());
                continue;
            }
            if (o instanceof OJAnnotationValue) {
                copy.values.add(((OJAnnotationValue)o).getDeepCopy());
                continue;
            }
            copy.values.add(o);
        }
    }

    private static String toLiteralString(Object o) {
        if (o instanceof Boolean || o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof OJPathName) {
            return ((OJPathName)o).getLast() + ".class";
        }
        if (o instanceof OJEnumValue) {
            return ((OJEnumValue)o).toJavaString();
        }
        if (o instanceof OJAnnotationValue) {
            return "\n" + ((OJAnnotationValue)o).toJavaString();
        }
        return "?";
    }

    public List<OJAnnotationValue> getAnnotationValues() {
        return this.getValuesOf(OJAnnotationValue.class);
    }

    public List<String> getStringValues() {
        return this.getValuesOf(String.class);
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        for (Object object : this.values) {
            if (!(object instanceof OJElement)) continue;
            ((OJElement)object).renameAll(renamePathNames, newName);
        }
    }

    private <T> List<T> getValuesOf(Class<T> c) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object value : this.values) {
            if (value.getClass() != c) continue;
            results.add(value);
        }
        return results;
    }
}

