/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.utilities;

import java.util.StringTokenizer;

public class JavaStringHelpers {
    public static String newLine = System.getProperty("line.separator", "\n");
    public static char newLineChar = newLine.charAt(0);

    public static String[] convertValuesFromString(String value, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(value, delimiter);
        int tokenCount = tokenizer.countTokens();
        String[] elements = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            elements[i] = tokenizer.nextToken();
        }
        return elements;
    }

    public static String convertValuesToString(String[] elements, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            buffer.append(elements[i]);
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String addBrackets(String source) {
        if (source.indexOf(32) != -1) {
            source = "(" + source + ")";
        }
        return source;
    }

    public static String firstCharToLower(String orig) {
        String result = "";
        String origFirst = orig.substring(0, 1);
        result = origFirst.toLowerCase();
        result = result + orig.substring(1, orig.length());
        return result;
    }

    public static String firstCharToUpper(String orig) {
        String result = "";
        String origFirst = orig.substring(0, 1);
        result = origFirst.toUpperCase();
        result = result + orig.substring(1, orig.length());
        return result;
    }

    public static String indent(String in, int level) {
        if (level <= 0) {
            return in;
        }
        StringBuilder result = JavaStringHelpers.internalIndent(in, level);
        return result.toString();
    }

    public static StringBuilder indent(StringBuilder in, int level) {
        if (level <= 0) {
            return in;
        }
        StringBuilder result = JavaStringHelpers.internalIndent(in.toString(), level);
        return result;
    }

    private static StringBuilder internalIndent(String in, int level) {
        StringBuilder result = new StringBuilder();
        String newIndent = "";
        for (int i = 0; i < level; ++i) {
            newIndent = newIndent + "\t";
        }
        String temp = in.toString();
        temp.trim();
        temp = newIndent + JavaStringHelpers.replaceAllSubstrings(temp, "\n", "\n" + newIndent);
        result.append(temp);
        if (result.charAt(result.length() - 1) == '\t') {
            result.deleteCharAt(result.length() - 1);
        }
        return result;
    }

    public static String replaceAllSubstrings(String orig, String origSub, String newSub) {
        return orig.replaceAll(origSub, newSub);
    }

    public static StringBuilder replaceAllSubstrings(StringBuilder orig, String origSub, String newSub) {
        StringBuilder result = new StringBuilder();
        result.append(orig.toString().replaceAll(origSub, newSub));
        return result;
    }

    public static String replaceFirstSubstring(String orig, String origSub, String newSub) {
        int first = orig.indexOf(origSub);
        if (first == -1) {
            return orig;
        }
        int last = first + origSub.length();
        String result = orig.substring(0, first);
        result = result + newSub + orig.substring(last);
        return result;
    }

    public static String replaceLastSubstring(String orig, String origSub, String newSub) {
        int first = orig.lastIndexOf(origSub);
        if (first == -1) {
            return orig;
        }
        int last = first + origSub.length();
        String result = orig.substring(0, first);
        result = result + newSub + orig.substring(last);
        return result;
    }

    public static void trimTrailingWhiteSpace(StringBuilder innerBody) {
        while (Character.isWhitespace(innerBody.charAt(innerBody.length() - 1))) {
            innerBody.deleteCharAt(innerBody.length() - 1);
        }
    }
}

