/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloneUtil {
    public static <T> T cloneDeep(T value) {
        if (value instanceof List) {
            return (T)CloneUtil.cloneList((List)value);
        }
        if (value instanceof Set) {
            return (T)CloneUtil.cloneSet((Set)value);
        }
        if (value instanceof Map) {
            return (T)CloneUtil.cloneMap((Map)value);
        }
        if (value instanceof Cloneable || value.getClass().isArray()) {
            return CloneUtil.cloneReflective(value);
        }
        return value;
    }

    public static <T> T cloneReflective(T value) {
        try {
            return (T)value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("clone failed for value type " + value.getClass().getName() + ", e=" + e, e);
        }
    }

    private static Map cloneMap(Map value) {
        Map clone = CloneUtil.cloneReflective(value);
        for (Map.Entry e : clone.entrySet()) {
            e.setValue(CloneUtil.cloneDeep(e.getValue()));
        }
        return clone;
    }

    private static List cloneList(List value) {
        List clone = value.getClass().getName().equals("java.util.Arrays$ArrayList") ? Arrays.asList(value.toArray()) : CloneUtil.cloneReflective(value);
        for (int i = 0; i < clone.size(); ++i) {
            clone.set(i, CloneUtil.cloneDeep(clone.get(i)));
        }
        return clone;
    }

    private static Set cloneSet(Set value) {
        Set clone = CloneUtil.cloneReflective(value);
        clone.clear();
        for (Object element : value) {
            clone.add(CloneUtil.cloneDeep(element));
        }
        return clone;
    }

    private CloneUtil() {
    }
}

