/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

public class Java7Util {
    public static final String JAVA7_CLASS_NAME_SUFFIX = "7";

    public static final boolean isJava7() {
        return System.getProperty("java.version").startsWith("1.7");
    }

    public static <T> T newInstance(Class<T> baseClass, T defaultInstance) {
        Class<T> clazz = Java7Util.loadClass(baseClass);
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return defaultInstance;
        }
    }

    public static <T> Class<? extends T> loadClass(Class<T> baseClass) {
        Class<?> java7Class;
        if (baseClass == null) {
            throw new NullPointerException("baseClass cannot be null");
        }
        try {
            java7Class = Class.forName(baseClass.getName() + JAVA7_CLASS_NAME_SUFFIX);
        }
        catch (ClassNotFoundException e) {
            return baseClass;
        }
        if (baseClass.isAssignableFrom(java7Class)) {
            return java7Class.asSubclass(baseClass);
        }
        throw new IllegalArgumentException("class " + java7Class.getName() + " is not a subclass of " + baseClass.getName());
    }
}

