/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.util.Comparator;

public class TrimBlanksStringComparator
implements Comparator<String> {
    private final Mode mode;
    private final Comparator<? super CharSequence> comparator;

    public TrimBlanksStringComparator(Mode mode, Comparator<? super CharSequence> comparator) {
        this.mode = mode;
        this.comparator = comparator;
    }

    @Override
    public int compare(String s1, String s2) {
        int start1 = this.findStart(s1);
        int end1 = this.findEnd(s1);
        int start2 = this.findStart(s2);
        int end2 = this.findEnd(s2);
        return this.comparator.compare(s1.subSequence(start1, end1), s2.subSequence(start2, end2));
    }

    private int findStart(String s) {
        if (this.mode == Mode.Trailing) {
            return 0;
        }
        return TrimBlanksStringComparator.findStartTrimBlanks(s);
    }

    static int findStartTrimBlanks(CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == ' ' || ch == '\t') continue;
            return i;
        }
        return len;
    }

    private int findEnd(String s) {
        if (this.mode == Mode.Leading) {
            return s.length();
        }
        return TrimBlanksStringComparator.findEndTrimBlanks(s);
    }

    static int findEndTrimBlanks(CharSequence s) {
        for (int i = s.length(); i > 0; --i) {
            char ch = s.charAt(i - 1);
            if (ch == ' ' || ch == '\t') continue;
            return i;
        }
        return 0;
    }

    public static enum Mode {
        Leading,
        Trailing,
        Both;

    }
}

