/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.basicBroadcast;

import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelInit;
import org.vanilladb.comm.protocols.events.BroadcastEvent;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;

public class BasicBroadcastSession
extends Session {
    private ProcessSet processes;

    public BasicBroadcastSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof BroadcastEvent) {
            if (event.getDir() == -1) {
                this.bebBroadcast((BroadcastEvent)event);
            } else {
                this.pp2pDeliver((BroadcastEvent)event);
            }
        } else if (event instanceof Crash) {
            this.handleCrash((Crash)event);
        } else if (event instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)event);
        } else if (event instanceof ProcessInitEvent) {
            this.handleProcessInitEvent((ProcessInitEvent)event);
        }
    }

    private void handleProcessInitEvent(ProcessInitEvent event) {
        this.processes = event.getProcessSet();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleChannelInit(ChannelInit init) {
        try {
            init.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void bebBroadcast(BroadcastEvent event) {
        SampleProcess[] processArray = this.processes.getAllProcesses();
        BroadcastEvent sendingEvent = null;
        int i = 0;
        while (i < processArray.length) {
            if (processArray[i].isCorrect()) {
                try {
                    sendingEvent = i == processArray.length - 1 ? event : (SendableEvent)event.cloneEvent();
                    sendingEvent.source = this.processes.getSelfProcess().getSocketAddress();
                    sendingEvent.dest = processArray[i].getSocketAddress();
                    sendingEvent.setSourceSession(this);
                    if (i == this.processes.getSelfRank()) {
                        sendingEvent.setDir(1);
                    }
                    sendingEvent.init();
                    sendingEvent.go();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    return;
                }
                catch (AppiaEventException e) {
                    e.printStackTrace();
                    return;
                }
            }
            ++i;
        }
    }

    private void pp2pDeliver(BroadcastEvent event) {
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleCrash(Crash crash) {
        int crashedProcess = crash.getCrashedProcess();
        Logger.getLogger(BasicBroadcastSession.class.getName()).fine("Process " + crashedProcess + " failed.");
        this.processes.getProcess(crashedProcess).setCorrect(false);
        try {
            crash.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }
}

