/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.causalEagerRb;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.channel.ChannelInit;
import org.vanilladb.comm.protocols.events.BroadcastEvent;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.utils.Debug;
import org.vanilladb.comm.protocols.utils.MessageID;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;

public class CausalEagerRBSession
extends Session {
    private ProcessSet processes;
    private long seqNumber = 0L;
    private long[] expectedDeliverNumbers;
    private Map<MessageID, BroadcastEvent> received;

    public CausalEagerRBSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)event);
        } else if (event instanceof ProcessInitEvent) {
            this.handleProcessInitEvent((ProcessInitEvent)event);
        } else if (event instanceof BroadcastEvent) {
            if (event.getDir() == -1) {
                this.rbBroadcast((BroadcastEvent)event);
            } else {
                this.bebDeliver((BroadcastEvent)event);
            }
        } else if (event instanceof Crash) {
            this.handleCrash((Crash)event);
        }
    }

    private void handleChannelInit(ChannelInit init) {
        try {
            init.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        this.received = new HashMap<MessageID, BroadcastEvent>();
    }

    private void handleProcessInitEvent(ProcessInitEvent event) {
        this.processes = event.getProcessSet();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        this.expectedDeliverNumbers = new long[this.processes.getSize()];
        for (int i = 0; i < this.processes.getSize(); ++i) {
            this.expectedDeliverNumbers[i] = 0L;
        }
    }

    private void rbBroadcast(BroadcastEvent event) {
        SampleProcess self = this.processes.getSelfProcess();
        MessageID msgID = new MessageID(self.getProcessNumber(), this.seqNumber);
        ++this.seqNumber;
        Debug.print("RB: broadcasting message.");
        event.getMessage().pushObject((Object)msgID);
        this.bebBroadcast(event);
    }

    private void bebDeliver(BroadcastEvent event) {
        Debug.print("RB: Received message from beb.");
        MessageID msgID = (MessageID)event.getMessage().peekObject();
        if (msgID.seqNumber >= this.expectedDeliverNumbers[msgID.process]) {
            Debug.print("RB: message is new.");
            BroadcastEvent retransmission = null;
            try {
                retransmission = (BroadcastEvent)event.cloneEvent();
            }
            catch (CloneNotSupportedException e1) {
                e1.printStackTrace();
            }
            event.getMessage().popObject();
            this.received.put(msgID, event);
            if (msgID.seqNumber == this.expectedDeliverNumbers[msgID.process]) {
                BroadcastEvent ev;
                while ((ev = this.received.remove(msgID)) != null) {
                    try {
                        ev.go();
                    }
                    catch (AppiaEventException e) {
                        e.printStackTrace();
                    }
                    ++msgID.seqNumber;
                }
                this.expectedDeliverNumbers[msgID.process] = msgID.seqNumber;
            }
            this.bebBroadcast(retransmission);
        }
    }

    private void bebBroadcast(BroadcastEvent event) {
        Debug.print("RB: sending message to beb.");
        try {
            event.setDir(-1);
            event.setSourceSession(this);
            event.init();
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleCrash(Crash crash) {
        int pi = crash.getCrashedProcess();
        Logger.getLogger(CausalEagerRBSession.class.getName()).fine("Process " + pi + " failed.");
        this.processes.getProcess(pi).setCorrect(false);
        try {
            crash.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }
}

