/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.consensusPaxos;

import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.protocols.consensusUtils.PaxosProposal;
import org.vanilladb.comm.protocols.events.Decided;
import org.vanilladb.comm.protocols.events.PaxosPropose;
import org.vanilladb.comm.protocols.events.PaxosReturn;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.events.UcDecide;
import org.vanilladb.comm.protocols.events.UcPropose;
import org.vanilladb.comm.protocols.utils.ProcessSet;

public class ConsensusPaxosSession
extends Session {
    private Channel channel;
    private ProcessSet correct = null;
    private PaxosProposal proposal = null;
    boolean proposed;
    boolean decided;

    public ConsensusPaxosSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof ProcessInitEvent) {
            this.handleProcessInit((ProcessInitEvent)event);
        } else if (event instanceof UcPropose) {
            this.handleUcPropose((UcPropose)event);
        } else if (event instanceof PaxosReturn) {
            this.handleAcReturn((PaxosReturn)event);
        } else if (event instanceof Decided) {
            this.handleDecided((Decided)event);
        } else {
            try {
                event.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void init() {
        this.proposed = false;
        this.decided = false;
    }

    private void handleProcessInit(ProcessInitEvent event) {
        this.correct = event.getProcessSet();
        this.channel = event.getChannel();
        this.init();
        try {
            event.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleUcPropose(UcPropose p) {
        this.proposal = p.value;
        this.tryPropose();
    }

    private void tryPropose() {
        if (!this.proposed) {
            this.proposed = true;
            try {
                PaxosPropose event = new PaxosPropose(this.channel, -1, this);
                event.value = this.proposal;
                event.setSourceSession(this);
                event.init();
                event.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleAcReturn(PaxosReturn result) {
        if (!result.decision.abort) {
            try {
                Decided event = new Decided();
                event.value = result.decision;
                event.setDir(-1);
                event.setSourceSession(this);
                event.init();
                event.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        } else {
            this.proposed = false;
            this.tryPropose();
        }
    }

    private void handleDecided(Decided v) {
        this.decided = true;
        try {
            UcDecide event = new UcDecide(this.channel, 1, this);
            event.decision = v.value;
            event.setSourceSession(this);
            event.init();
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }
}

