/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.consensusUTO;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.core.message.Message;
import org.vanilladb.comm.protocols.consensusUTO.ListElement;
import org.vanilladb.comm.protocols.consensusUTO.OrderProposal;
import org.vanilladb.comm.protocols.events.ConsensusDecide;
import org.vanilladb.comm.protocols.events.ConsensusPropose;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.utils.Debug;

public class ConsensusUTOSession
extends Session {
    private SocketAddress iwp;
    private Channel channel;
    private int seqNumber;
    private int sn;
    private boolean wait;
    private LinkedList<ListElement> delivered;
    private LinkedList<ListElement> unordered;

    public ConsensusUTOSession(Layer l) {
        super(l);
    }

    public void handle(Event e) {
        if (e instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)e);
        } else if (e instanceof ProcessInitEvent) {
            this.handleProcessInitEvent((ProcessInitEvent)e);
        } else if (e instanceof SendableEvent) {
            if (e.getDir() == -1) {
                this.handleSendableEventDOWN((SendableEvent)e);
            } else {
                this.handleSendableEventUP((SendableEvent)e);
            }
        } else if (e instanceof ConsensusDecide) {
            this.handleConsensusDecide((ConsensusDecide)e);
        } else {
            try {
                e.go();
            }
            catch (AppiaEventException ex) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:handle]" + ex.getMessage());
            }
        }
    }

    public void handleChannelInit(ChannelInit e) {
        Debug.print("TO: handle: " + e.getClass().getName());
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:handleCI]:1:" + ex.getMessage());
        }
        this.channel = e.getChannel();
        this.delivered = new LinkedList();
        this.unordered = new LinkedList();
        this.sn = 1;
        this.wait = false;
    }

    public void handleProcessInitEvent(ProcessInitEvent e) {
        this.iwp = e.getProcessSet().getSelfProcess().getSocketAddress();
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:handlePI]:1:" + ex.getMessage());
        }
    }

    public void handleSendableEventDOWN(SendableEvent e) {
        Debug.print("TO: handle: " + e.getClass().getName() + " DOWN");
        Message om = e.getMessage();
        om.pushInt(this.seqNumber);
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:handleDOWN]" + ex.getMessage());
        }
        ++this.seqNumber;
    }

    public void handleSendableEventUP(SendableEvent e) {
        Debug.print("TO: handle: " + e.getClass().getName() + " UP");
        Message om = e.getMessage();
        int seq = om.popInt();
        if (!this.isDelivered((SocketAddress)e.source, seq)) {
            ListElement le = new ListElement(e, seq);
            this.unordered.add(le);
        }
        if (this.unordered.size() != 0 && !this.wait) {
            this.wait = true;
            byte[] bytes = null;
            try {
                ConsensusPropose cp = new ConsensusPropose(this.channel, -1, this);
                bytes = this.serialize(this.unordered);
                OrderProposal op = new OrderProposal(bytes);
                cp.value = op;
                cp.go();
                Debug.print("TO: handleUP: Proposta:");
                for (int g = 0; g < this.unordered.size(); ++g) {
                    Debug.print("source:" + this.unordered.get((int)g).se.source + " seq:" + this.unordered.get((int)g).seq);
                }
                Debug.print("TO: handleUP: Proposta feita!");
            }
            catch (AppiaEventException ex) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:handleUP]" + ex.getMessage());
            }
        }
    }

    public void handleConsensusDecide(ConsensusDecide e) {
        Debug.print("TO: handle: " + ((Object)((Object)e)).getClass().getName());
        LinkedList<ListElement> decided = this.deserialize(((OrderProposal)e.decision).bytes);
        for (int i = 0; i < decided.size(); ++i) {
            if (this.isDelivered((SocketAddress)decided.get((int)i).se.source, decided.get((int)i).seq)) continue;
            this.delivered.add(decided.get(i));
        }
        for (int j = 0; j < this.unordered.size(); ++j) {
            if (!this.isDelivered((SocketAddress)this.unordered.get((int)j).se.source, this.unordered.get((int)j).seq)) continue;
            this.unordered.remove(j);
            --j;
        }
        decided = this.sort(decided);
        for (int k = 0; k < decided.size(); ++k) {
            try {
                decided.get((int)k).se.go();
                continue;
            }
            catch (AppiaEventException ex) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:handleDecide]" + ex.getMessage());
            }
        }
        ++this.sn;
        this.wait = false;
    }

    boolean isDelivered(SocketAddress source, int seq) {
        for (int k = 0; k < this.delivered.size(); ++k) {
            if (!this.delivered.get((int)k).getSE().source.equals(source) || this.delivered.get(k).getSeq() != seq) continue;
            return true;
        }
        return false;
    }

    LinkedList<ListElement> sort(LinkedList<ListElement> list) {
        return list;
    }

    byte[] intToByteArray(int i) {
        byte[] ret = new byte[]{(byte)((i & 0xFF000000) >> 24), (byte)((i & 0xFF0000) >> 16), (byte)((i & 0xFF00) >> 8), (byte)(i & 0xFF)};
        return ret;
    }

    int byteArrayToInt(byte[] b, int off) {
        int ret = 0;
        ret |= b[off] << 24;
        ret |= b[off + 1] << 24 >>> 8;
        ret |= b[off + 2] << 24 >>> 16;
        return ret |= b[off + 3] << 24 >>> 24;
    }

    private byte[] serialize(LinkedList<ListElement> list) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] bytes = null;
        try {
            data.write(this.intToByteArray(list.size()));
            for (int i = 0; i < list.size(); ++i) {
                ListElement le = list.get(i);
                data.write(this.intToByteArray(le.seq));
                bytes = le.se.getClass().getName().getBytes();
                data.write(this.intToByteArray(bytes.length));
                data.write(bytes, 0, bytes.length);
                data.write(this.intToByteArray(((InetSocketAddress)le.se.source).getPort()));
                String host = ((InetSocketAddress)le.se.source).getAddress().getHostAddress();
                bytes = host.getBytes();
                data.write(this.intToByteArray(bytes.length));
                data.write(bytes, 0, bytes.length);
                bytes = le.se.getMessage().toByteArray();
                data.write(this.intToByteArray(bytes.length));
                data.write(bytes, 0, bytes.length);
            }
        }
        catch (IOException e) {
            Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:serialize]" + e.getMessage());
        }
        bytes = data.toByteArray();
        return bytes;
    }

    private LinkedList<ListElement> deserialize(byte[] data) {
        LinkedList<ListElement> ret = new LinkedList<ListElement>();
        int curPos = 0;
        int listSize = this.byteArrayToInt(data, curPos);
        curPos += 4;
        for (int i = 0; i < listSize; ++i) {
            try {
                int seq = this.byteArrayToInt(data, curPos);
                int aux_size = this.byteArrayToInt(data, curPos += 4);
                String className = new String(data, curPos + 4, aux_size);
                curPos += aux_size + 4;
                SendableEvent se = null;
                se = (SendableEvent)Class.forName(className).newInstance();
                se.setDir(1);
                se.setSourceSession((Session)this);
                se.setChannel(this.channel);
                int port = this.byteArrayToInt(data, curPos);
                aux_size = this.byteArrayToInt(data, curPos += 4);
                String host = new String(data, curPos + 4, aux_size);
                curPos += aux_size + 4;
                se.source = new InetSocketAddress(InetAddress.getByName(host), port);
                aux_size = this.byteArrayToInt(data, curPos);
                se.getMessage().setByteArray(data, curPos += 4, aux_size);
                curPos += aux_size;
                se.init();
                ListElement le = new ListElement(se, seq);
                ret.add(le);
                continue;
            }
            catch (InstantiationException e) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:DEserialize]:1: " + e.getMessage());
                continue;
            }
            catch (IllegalAccessException e) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:DEserialize]:2: " + e.getMessage());
                continue;
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:DEserialize]:3: " + e.getMessage());
                continue;
            }
            catch (UnknownHostException e) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:DEserialize]:4: " + e.getMessage());
                continue;
            }
            catch (AppiaEventException e) {
                Logger.getLogger(ConsensusUTOSession.class.getName()).fine("[ConsensusUTOSession:DEserialize]:5: " + e.getMessage());
            }
        }
        return ret;
    }
}

