/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.eagerRb;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.channel.ChannelInit;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.events.ReliableBroadcastEvent;
import org.vanilladb.comm.protocols.utils.Debug;
import org.vanilladb.comm.protocols.utils.MessageID;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;

public class EagerRBSession
extends Session {
    private ProcessSet processes;
    private long seqNumber = 0L;
    private long[] deliveredNumbers;
    private final int DELIVERED_SHRINK_SIZE = 100;
    private Set<MessageID> delivered;

    public EagerRBSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof ReliableBroadcastEvent) {
            if (event.getDir() == -1) {
                this.rbBroadcast((ReliableBroadcastEvent)event);
            } else {
                this.bebDeliver((ReliableBroadcastEvent)event);
            }
        } else if (event instanceof Crash) {
            this.handleCrash((Crash)event);
        } else if (event instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)event);
        } else if (event instanceof ProcessInitEvent) {
            this.handleProcessInitEvent((ProcessInitEvent)event);
        }
    }

    private void handleChannelInit(ChannelInit init) {
        try {
            init.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        this.delivered = new HashSet<MessageID>();
    }

    private void handleProcessInitEvent(ProcessInitEvent event) {
        this.processes = event.getProcessSet();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        this.deliveredNumbers = new long[this.processes.getSize()];
        for (int i = 0; i < this.processes.getSize(); ++i) {
            this.deliveredNumbers[i] = -1L;
        }
    }

    private void rbBroadcast(ReliableBroadcastEvent event) {
        SampleProcess self = this.processes.getSelfProcess();
        MessageID msgID = new MessageID(self.getProcessNumber(), this.seqNumber);
        ++this.seqNumber;
        Debug.print("RB: broadcasting message.");
        event.getMessage().pushObject((Object)msgID);
        this.bebBroadcast(event);
    }

    private void bebDeliver(ReliableBroadcastEvent event) {
        MessageID msgID = (MessageID)event.getMessage().peekObject();
        if (msgID.seqNumber > this.deliveredNumbers[msgID.process] && !this.delivered.contains(msgID)) {
            Debug.print("RB: message is new.");
            this.delivered.add(msgID);
            ReliableBroadcastEvent retransmission = null;
            try {
                retransmission = (ReliableBroadcastEvent)event.cloneEvent();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return;
            }
            event.getMessage().popObject();
            try {
                event.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
            this.bebBroadcast(retransmission);
            if (this.delivered.size() < 100) {
                this.shrinkDelivered(msgID);
                return;
            }
        }
    }

    private void bebBroadcast(ReliableBroadcastEvent event) {
        try {
            event.setDir(-1);
            event.setSourceSession(this);
            event.init();
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleCrash(Crash crash) {
        int pi = crash.getCrashedProcess();
        Logger.getLogger(EagerRBSession.class.getName()).fine("Process " + pi + " failed.");
        this.processes.getProcess(pi).setCorrect(false);
        try {
            crash.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void shrinkDelivered(MessageID mid) {
        int pid = mid.process;
        long sn = mid.seqNumber;
        long old_sn = this.deliveredNumbers[pid];
        MessageID tmid = new MessageID(pid, old_sn);
        long i = old_sn + 1L;
        while (i <= sn) {
            tmid.seqNumber = i++;
            if (!this.delivered.remove(tmid)) break;
        }
        this.deliveredNumbers[pid] = i - 1L;
    }
}

