/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.uniformFloodingConsensus;

import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.protocols.consensusUtils.Proposal;
import org.vanilladb.comm.protocols.events.ConsensusDecide;
import org.vanilladb.comm.protocols.events.ConsensusPropose;
import org.vanilladb.comm.protocols.events.Crash;
import org.vanilladb.comm.protocols.events.ProcessInitEvent;
import org.vanilladb.comm.protocols.uniformFloodingConsensus.MySetEvent;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;

public class UniformFloodingConsensusSession
extends Session {
    private int round = -1;
    private ProcessSet correct = null;
    private Proposal decided = null;
    private List<HashSet<SampleProcess>> delivered = null;
    private HashSet<Proposal> proposal_set = null;
    public static final boolean debugFull = false;
    private PrintStream debug = System.out;

    public UniformFloodingConsensusSession(Layer layer) {
        super(layer);
    }

    public void handle(Event event) {
        if (event instanceof ProcessInitEvent) {
            this.handleProcessInit((ProcessInitEvent)event);
        } else if (event instanceof Crash) {
            this.handleCrash((Crash)event);
        } else if (event instanceof ConsensusPropose) {
            this.handleConsensusPropose((ConsensusPropose)event);
        } else if (event instanceof MySetEvent) {
            this.handleMySet((MySetEvent)event);
        } else {
            this.debug("Unwanted event received, ignoring.");
            try {
                event.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void init() {
        int max_rounds = this.correct.getSize();
        this.delivered = new ArrayList<HashSet<SampleProcess>>(max_rounds);
        this.proposal_set = new HashSet();
        for (int i = 0; i < max_rounds; ++i) {
            this.delivered.add(i, new HashSet());
        }
        this.round = 0;
        this.decided = null;
    }

    private void handleProcessInit(ProcessInitEvent event) {
        this.correct = event.getProcessSet();
        this.init();
        try {
            event.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleCrash(Crash crash) {
        this.correct.setCorrect(crash.getCrashedProcess(), false);
        try {
            crash.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
        this.debug("received crash for " + crash.getCrashedProcess());
        this.decide(crash.getChannel());
    }

    private void handleConsensusPropose(ConsensusPropose propose) {
        this.proposal_set.add(propose.value);
        try {
            MySetEvent ev = new MySetEvent(propose.getChannel(), -1, this);
            ev.getMessage().pushObject(this.proposal_set);
            ev.getMessage().pushInt(this.round);
            ev.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleMySet(MySetEvent event) {
        SampleProcess p_i = this.correct.getProcess((SocketAddress)event.source);
        int round = event.getMessage().popInt();
        HashSet newSet = (HashSet)event.getMessage().popObject();
        this.proposal_set.addAll(newSet);
        this.delivered.get(round).add(p_i);
        this.decide(event.getChannel());
    }

    private void decide(Channel channel) {
        Object ev;
        this.debugAll("decide");
        if (this.decided != null) {
            return;
        }
        for (int i = 0; i < this.correct.getSize(); ++i) {
            SampleProcess p = this.correct.getProcess(i);
            if (p == null || !p.isCorrect() || this.delivered.get(this.round).contains(p)) continue;
            return;
        }
        if (this.round == this.delivered.size() - 1) {
            for (Proposal proposal : this.proposal_set) {
                if (this.decided == null) {
                    this.decided = proposal;
                    continue;
                }
                if (proposal.compareTo(this.decided) >= 0) continue;
                this.decided = proposal;
            }
            try {
                ev = new ConsensusDecide(channel, 1, this);
                ((ConsensusDecide)((Object)ev)).decision = this.decided;
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
            this.init();
        } else {
            ++this.round;
            try {
                ev = new MySetEvent(channel, -1, this);
                ev.getMessage().pushObject(this.proposal_set);
                ev.getMessage().pushInt(this.round);
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void debug(String s) {
        if (this.debug != null) {
            // empty if block
        }
    }

    private void debugAll(String s) {
        if (this.debug != null) {
            // empty if block
        }
    }
}

