/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.utils;

import java.io.Serializable;
import java.net.SocketAddress;

public class SampleProcess
implements Serializable {
    private static final long serialVersionUID = 3677871909022936117L;
    private SocketAddress address;
    private int processNumber;
    private boolean self;
    private boolean correct;
    private boolean initialized;

    public SampleProcess(SocketAddress addr, int proc, boolean self) {
        this.address = addr;
        this.processNumber = proc;
        this.self = self;
        this.correct = true;
        this.initialized = false;
    }

    public SocketAddress getSocketAddress() {
        return this.address;
    }

    public int getProcessNumber() {
        return this.processNumber;
    }

    public boolean isSelf() {
        return this.self;
    }

    public boolean equals(Object test) {
        if (test == this) {
            return true;
        }
        if (test == null) {
            return false;
        }
        if (!(test instanceof SampleProcess)) {
            return false;
        }
        SampleProcess proc = (SampleProcess)test;
        return this.address.equals(proc.address) && this.processNumber == proc.processNumber && this.self == proc.self;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.address.hashCode();
        hash = hash * 31 + this.processNumber;
        hash = hash * 31 + (this.self ? 1 : 0);
        return hash;
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public void setCorrect(boolean b) {
        this.correct = b;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public SampleProcess cloneProcess() {
        SampleProcess p = new SampleProcess(this.address, this.processNumber, this.self);
        p.correct = this.correct;
        p.initialized = this.initialized;
        return p;
    }
}

