/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.server;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.Appia;
import net.sf.appia.core.AppiaCursorException;
import net.sf.appia.core.AppiaDuplicatedSessionsException;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaInvalidQoSException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.ChannelCursor;
import net.sf.appia.core.Layer;
import net.sf.appia.core.QoS;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteLayer;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteSession;
import org.vanilladb.comm.client.ClientAppl;
import org.vanilladb.comm.messages.ChannelType;
import org.vanilladb.comm.messages.NodeFailListener;
import org.vanilladb.comm.messages.P2pMessage;
import org.vanilladb.comm.messages.P2pMessageListener;
import org.vanilladb.comm.messages.TotalOrderMessage;
import org.vanilladb.comm.messages.TotalOrderedMessageListener;
import org.vanilladb.comm.protocols.basicBroadcast.BasicBroadcastLayer;
import org.vanilladb.comm.protocols.events.ZabRequest;
import org.vanilladb.comm.protocols.serverClientAppl.ServerClientApplLayer;
import org.vanilladb.comm.protocols.serverClientAppl.ServerClientApplSession;
import org.vanilladb.comm.protocols.tcpBasedPFD.PFDStartEvent;
import org.vanilladb.comm.protocols.tcpBasedPFD.TcpBasedPFDLayer;
import org.vanilladb.comm.protocols.tcpBasedPFD.TcpBasedPFDSession;
import org.vanilladb.comm.protocols.utils.ProcessSet;
import org.vanilladb.comm.protocols.utils.SampleProcess;
import org.vanilladb.comm.protocols.zabAccept.ZabAcceptLayer;
import org.vanilladb.comm.protocols.zabAppl.ZabApplLayer;
import org.vanilladb.comm.protocols.zabAppl.ZabApplSession;
import org.vanilladb.comm.protocols.zabTotalOrder.ZabTOBLayer;
import org.vanilladb.comm.server.ServerNodeFailListener;
import org.vanilladb.comm.server.ServerP2pMessageListener;
import org.vanilladb.comm.server.ServerTotalOrderedMessageListener;

public class ServerAppl
extends Thread
implements TotalOrderedMessageListener,
P2pMessageListener,
NodeFailListener {
    private final boolean IS_STANDALONE_SEQUENCER;
    private ProcessSet dbServerProcessSet;
    private ProcessSet[] clientParticipatedProcessSets;
    private Channel zabChannel;
    private Channel clientChannel;
    private ProcessSet clientParticipatedProcessSet;
    private Channel[] serverChannels;
    private Channel[] clientChannels;
    private String serverView;
    private String clientView;
    private ServerTotalOrderedMessageListener svTomListener;
    private ServerP2pMessageListener svP2pMListener;
    private ServerNodeFailListener nfListener;
    private int selfId;
    private int leaderId;
    private long tomTime;

    public ServerAppl(int selfId, ServerTotalOrderedMessageListener svTomListener, ServerP2pMessageListener svP2pMListener, ServerNodeFailListener nfListener) {
        String prop;
        block16: {
            this.leaderId = 0;
            this.tomTime = 0L;
            this.selfId = selfId;
            this.svTomListener = svTomListener;
            this.svP2pMListener = svP2pMListener;
            this.nfListener = nfListener;
            if (svTomListener == null || svP2pMListener == null || nfListener == null) {
                throw new IllegalArgumentException("Must implement RequestListener, TupleSetListener and NodeFailListener");
            }
            String path = System.getProperty("org.vanilladb.comm.config.file");
            if (path != null) {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(path);
                        System.getProperties().load(fis);
                    }
                    catch (IOException iOException) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException2) {}
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.serverView = prop = System.getProperty(String.valueOf(ServerAppl.class.getName()) + ".SERVER_VIEW");
        this.clientView = prop = System.getProperty(String.valueOf(ClientAppl.class.getName()) + ".CLIENT_VIEW");
        prop = System.getProperty(String.valueOf(ServerAppl.class.getName()) + ".STAND_ALONE_SEQUENCER");
        this.IS_STANDALONE_SEQUENCER = prop != null ? Boolean.parseBoolean(prop) : false;
    }

    @Override
    public void run() {
        ProcessSet dbServerProcessSet;
        this.dbServerProcessSet = dbServerProcessSet = this.buildProcessSet(this.serverView, this.selfId);
        ProcessSet clientProcessSet = this.buildProcessSet(this.clientView, this.selfId);
        this.leaderId = this.IS_STANDALONE_SEQUENCER ? dbServerProcessSet.getSize() - 1 : 0;
        try {
            this.zabChannel = this.getZabChannel(dbServerProcessSet);
            this.zabChannel.start();
            this.serverChannels = new Channel[dbServerProcessSet.getSize()];
            int i = 0;
            while (i < dbServerProcessSet.getSize()) {
                this.serverChannels[i] = this.getServersChannel(this.dbServerProcessSet, i);
                ++i;
            }
            this.clientChannels = new Channel[clientProcessSet.getSize()];
            this.clientParticipatedProcessSets = new ProcessSet[clientProcessSet.getSize()];
            this.clientParticipatedProcessSet = dbServerProcessSet.cloneProcessSet();
            i = 0;
            while (i < clientProcessSet.getSize()) {
                ProcessSet ps = dbServerProcessSet.cloneProcessSet();
                ps.addProcess(new SampleProcess(clientProcessSet.getProcess(i).getSocketAddress(), dbServerProcessSet.getSize(), false), dbServerProcessSet.getSize());
                this.clientParticipatedProcessSets[i] = ps;
                this.clientChannels[i] = this.getServerClientChannel(ps, i);
                this.clientParticipatedProcessSet.addProcess(new SampleProcess(clientProcessSet.getProcess(i).getSocketAddress(), dbServerProcessSet.getSize() + i, false), dbServerProcessSet.getSize() + i);
                ++i;
            }
            this.clientChannel = this.getServerClientChannel(this.clientParticipatedProcessSet, -1);
            this.clientChannel.start();
        }
        catch (AppiaDuplicatedSessionsException e) {
            e.printStackTrace();
        }
        Logger.getLogger(ServerAppl.class.getName()).info("Starting Appia...");
        Appia.run();
    }

    public void sendTotalOrderRequest(Object[] spcs) {
        TotalOrderMessage tom = new TotalOrderMessage(spcs);
        try {
            ZabRequest ev = new ZabRequest(this.zabChannel, -1, null, tom);
            ev.asyncGo(this.zabChannel, -1);
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    public void sendP2pMessage(P2pMessage c) {
        if (c.getGroup() == ChannelType.SERVER) {
            if (Logger.getLogger(ServerAppl.class.getName()).isLoggable(Level.FINE)) {
                Logger.getLogger(ServerAppl.class.getName()).fine("Server " + this.selfId + " sends message to server " + c.getReceiver());
            }
            try {
                SendableEvent ev = new SendableEvent();
                ev.getMessage().pushObject((Object)c);
                ev.source = this.dbServerProcessSet.getSelfProcess().getSocketAddress();
                ev.dest = this.dbServerProcessSet.getProcess(c.getReceiver()).getSocketAddress();
                ev.setSourceSession(null);
                ev.asyncGo(this.zabChannel, -1);
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        } else {
            if (Logger.getLogger(ServerAppl.class.getName()).isLoggable(Level.FINE)) {
                Logger.getLogger(ServerAppl.class.getName()).fine("Server " + this.selfId + " sends message to client " + c.getReceiver());
            }
            try {
                SendableEvent ev = new SendableEvent();
                ev.getMessage().pushObject((Object)c);
                ev.source = this.clientParticipatedProcessSet.getSelfProcess().getSocketAddress();
                ev.dest = this.clientParticipatedProcessSet.getProcess(this.dbServerProcessSet.getSize() + c.getReceiver()).getSocketAddress();
                ev.setSourceSession(null);
                ev.asyncGo(this.clientChannel, -1);
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void startPFD() {
        PFDStartEvent pfdStart = new PFDStartEvent();
        try {
            pfdStart.asyncGo(this.zabChannel, -1);
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRecvTotalOrderedMessage(TotalOrderMessage tom) {
        if (this.IS_STANDALONE_SEQUENCER && this.selfId == this.leaderId) {
            return;
        }
        this.svTomListener.onRecvServerTotalOrderedMessage(tom);
    }

    @Override
    public void onRecvP2pMessage(P2pMessage p2pm) {
        if (p2pm.getGroup() == ChannelType.SERVER) {
            this.svP2pMListener.onRecvServerP2pMessage(p2pm);
        } else if (p2pm.getGroup() == ChannelType.CLIENT) {
            TotalOrderMessage tom = new TotalOrderMessage((Object[])p2pm.getMessage());
            try {
                ZabRequest ev = new ZabRequest(this.zabChannel, -1, null, tom);
                ev.go();
            }
            catch (AppiaEventException ex) {
                ex.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void onNodeFail(int id, ChannelType channelType, Channel c) {
        this.dbServerProcessSet.getProcess(id).setCorrect(false);
        this.nfListener.onNodeFail(id, channelType);
    }

    private ProcessSet buildProcessSet(String str, int selfProc) {
        String[] machines;
        ProcessSet set = new ProcessSet();
        String[] stringArray = machines = str.split(",");
        int n = machines.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            try {
                StringTokenizer st = new StringTokenizer(m);
                if (st.countTokens() != 3) {
                    Logger.getLogger(ServerAppl.class.getName()).severe("Wrong line in file: " + st.countTokens());
                } else {
                    int procNumber = Integer.parseInt(st.nextToken());
                    InetAddress addr = InetAddress.getByName(st.nextToken());
                    int portNumber = Integer.parseInt(st.nextToken());
                    boolean self = procNumber == selfProc;
                    SampleProcess process = new SampleProcess(new InetSocketAddress(addr, portNumber), procNumber, self);
                    set.addProcess(process, procNumber);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
        return set;
    }

    private Channel getZabChannel(ProcessSet processes) {
        Layer[] qos = new Layer[]{new TcpCompleteLayer(), new TcpBasedPFDLayer(), new BasicBroadcastLayer(), new ZabAcceptLayer(), new ZabTOBLayer(), new ZabApplLayer()};
        QoS myQoS = null;
        try {
            myQoS = new QoS("ZAB QoS", qos);
        }
        catch (AppiaInvalidQoSException ex) {
            Logger.getLogger(ServerAppl.class.getName()).severe("Invalid QoS");
            Logger.getLogger(ServerAppl.class.getName()).severe(ex.getMessage());
            System.exit(1);
        }
        Channel channel = myQoS.createUnboundChannel("Zab Channel");
        ZabApplSession sas = (ZabApplSession)qos[qos.length - 1].createSession();
        sas.init(processes, this, this, this);
        ChannelCursor cc = channel.getCursor();
        TcpCompleteSession tcpsession = (TcpCompleteSession)qos[0].createSession();
        TcpBasedPFDSession tcppfdsession = (TcpBasedPFDSession)qos[1].createSession();
        try {
            cc.top();
            cc.setSession((Session)sas);
            cc.bottom();
            cc.setSession((Session)tcpsession);
            cc.up();
            cc.setSession((Session)tcppfdsession);
        }
        catch (AppiaCursorException ex) {
            Logger.getLogger(ServerAppl.class.getName()).severe("Unexpected exception in main. Type code:" + ex.type);
            System.exit(1);
        }
        return channel;
    }

    private Channel getServersChannel(ProcessSet processes, int id) {
        Layer[] qos = new Layer[]{new TcpCompleteLayer(), new TcpBasedPFDLayer(), new BasicBroadcastLayer(), new ServerClientApplLayer()};
        QoS myQoS = null;
        try {
            myQoS = new QoS("ServerClient QoS for server " + id, qos);
        }
        catch (AppiaInvalidQoSException ex) {
            Logger.getLogger(ServerAppl.class.getName()).severe("Invalid QoS");
            Logger.getLogger(ServerAppl.class.getName()).severe(ex.getMessage());
            System.exit(1);
        }
        Channel channel = myQoS.createUnboundChannel("ServerClient channel for server " + id);
        ServerClientApplSession sas = (ServerClientApplSession)qos[qos.length - 1].createSession();
        sas.init(processes, this, this, this, false);
        ChannelCursor cc = channel.getCursor();
        try {
            cc.top();
            cc.setSession((Session)sas);
            cc.bottom();
            ChannelCursor ccc = this.zabChannel.getCursor();
            ccc.bottom();
            cc.setSession(ccc.getSession());
            ccc.up();
            cc.up();
            cc.setSession(ccc.getSession());
        }
        catch (AppiaCursorException ex) {
            Logger.getLogger(ServerAppl.class.getName()).severe("Unexpected exception in main. Type code:" + ex.type);
            System.exit(1);
        }
        return channel;
    }

    private Channel getServerClientChannel(ProcessSet processes, int id) {
        Layer[] qos = new Layer[]{new TcpCompleteLayer(), new TcpBasedPFDLayer(), new ServerClientApplLayer()};
        QoS myQoS = null;
        try {
            myQoS = new QoS("ServerClient QoS for client " + id, qos);
        }
        catch (AppiaInvalidQoSException ex) {
            Logger.getLogger(ServerAppl.class.getName()).severe("Invalid QoS");
            Logger.getLogger(ServerAppl.class.getName()).severe(ex.getMessage());
            System.exit(1);
        }
        Channel channel = myQoS.createUnboundChannel("ServerClient channel for client " + id);
        ServerClientApplSession sas = (ServerClientApplSession)qos[qos.length - 1].createSession();
        sas.init(processes, this, this, false);
        ChannelCursor cc = channel.getCursor();
        try {
            cc.top();
            cc.setSession((Session)sas);
            cc.bottom();
            ChannelCursor ccc = this.zabChannel.getCursor();
            ccc.bottom();
            cc.setSession(ccc.getSession());
            ccc.up();
            cc.up();
            cc.setSession(ccc.getSession());
        }
        catch (AppiaCursorException ex) {
            Logger.getLogger(ServerAppl.class.getName()).severe("Unexpected exception in main. Type code:" + ex.type);
            System.exit(1);
        }
        return channel;
    }
}

