/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import java.io.File;
import java.io.IOException;
import net.sf.appia.core.Appia;
import net.sf.appia.core.AppiaException;
import net.sf.appia.xml.AppiaXML;
import net.sf.appia.xml.AppiaXMLException;
import org.xml.sax.SAXException;

public abstract class AbstractAppiaRunnable
implements Runnable {
    private Appia appia;
    private AppiaXML appiaXML;

    public AbstractAppiaRunnable() throws AppiaException {
        this.appia = new Appia();
        this.appiaXML = AppiaXML.getInstance(this.appia);
    }

    public AbstractAppiaRunnable(Appia appia) throws AppiaException {
        this.appia = appia;
        this.appiaXML = AppiaXML.getInstance(appia);
    }

    public AbstractAppiaRunnable(File xmlConfig, String managementID) throws AppiaXMLException {
        this.appia = new Appia();
        this.appia.setManagementMBeanID(managementID);
        this.appiaXML = AppiaXML.getInstance(this.appia);
        try {
            this.appiaXML.instanceLoad(xmlConfig, this.appia);
        }
        catch (SAXException e) {
            throw new AppiaXMLException("Error loading configuration", e);
        }
        catch (IOException e) {
            throw new AppiaXMLException("Error loading configuration", e);
        }
    }

    public AbstractAppiaRunnable(Appia appia, File xmlConfig) throws AppiaXMLException {
        this.appia = appia;
        this.appiaXML = AppiaXML.getInstance(appia);
        try {
            this.appiaXML.instanceLoad(xmlConfig, this.appia);
        }
        catch (SAXException e) {
            throw new AppiaXMLException("Error loading configuration", e);
        }
        catch (IOException e) {
            throw new AppiaXMLException("Error loading configuration", e);
        }
    }

    public abstract void setup() throws AppiaException;

    @Override
    public void run() {
        this.appia.instanceRun();
    }

    public Appia getAppia() {
        return this.appia;
    }

    public AppiaXML getAppiaXML() {
        return this.appiaXML;
    }
}

