/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import java.util.Hashtable;
import java.util.concurrent.ThreadFactory;
import net.sf.appia.core.AppiaDuplicatedSessionsException;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.AppiaMBeanContainer;
import net.sf.appia.core.ChannelCursor;
import net.sf.appia.core.ChannelEventRoute;
import net.sf.appia.core.Event;
import net.sf.appia.core.EventScheduler;
import net.sf.appia.core.Layer;
import net.sf.appia.core.ManagementServerFactory;
import net.sf.appia.core.QoS;
import net.sf.appia.core.QoSEventRoute;
import net.sf.appia.core.Session;
import net.sf.appia.core.TimeProvider;
import net.sf.appia.core.TimerManager;
import net.sf.appia.core.events.channel.ChannelClose;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.core.events.channel.Debug;
import net.sf.appia.core.events.channel.EchoEvent;
import net.sf.appia.core.events.channel.PeriodicTimer;
import net.sf.appia.core.events.channel.Timer;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.core.message.DefaultMessageFactory;
import net.sf.appia.core.message.MessageFactory;
import net.sf.appia.management.ManagedSession;
import net.sf.appia.management.SensorSession;
import net.sf.appia.management.jmx.ChannelManager;
import net.sf.appia.management.jmx.JMXConfiguration;
import net.sf.appia.protocols.common.AppiaThreadFactory;
import org.apache.log4j.Logger;

public class Channel {
    private static Logger log = Logger.getLogger(Channel.class);
    String channelID;
    private QoS qos;
    private Hashtable eventsRoutes = null;
    private EventScheduler eventScheduler;
    private TimerManager timerManager;
    private boolean alive = false;
    private boolean started = false;
    private MemoryManager memoryManager = null;
    private JMXConfiguration jmxConfiguration = null;
    private MessageFactory messageFactory = new DefaultMessageFactory();
    private ThreadFactory threadFactory = new AppiaThreadFactory();
    protected Session[] sessions = null;

    public Channel(String channelID, QoS qos, EventScheduler eventScheduler, JMXConfiguration jmxConfig) {
        this.channelID = channelID;
        this.qos = qos;
        this.eventScheduler = eventScheduler;
        this.sessions = new Session[qos.getLayers().length];
        this.timerManager = eventScheduler.getAppiaInstance().instanceGetTimerManager();
        this.threadFactory = eventScheduler.getAppiaInstance().getThreadFactory();
        this.jmxConfiguration = jmxConfig;
    }

    public Channel(String channelID, QoS qos, EventScheduler eventScheduler, MemoryManager memoryManager, JMXConfiguration jmxConfig) {
        this.channelID = channelID;
        this.qos = qos;
        this.eventScheduler = eventScheduler;
        this.sessions = new Session[qos.getLayers().length];
        this.timerManager = eventScheduler.getAppiaInstance().instanceGetTimerManager();
        this.threadFactory = eventScheduler.getAppiaInstance().getThreadFactory();
        this.memoryManager = memoryManager;
        this.jmxConfiguration = jmxConfig;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(MemoryManager newMemoryManager) {
        this.memoryManager = newMemoryManager;
    }

    public TimeProvider getTimeProvider() {
        return this.timerManager;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public String getChannelID() {
        return this.channelID;
    }

    public EventScheduler getEventScheduler() {
        return this.eventScheduler;
    }

    public ChannelEventRoute getEventRoute(Event event) throws AppiaEventException {
        if (this.eventsRoutes == null) {
            throw new AppiaEventException(6, "Channel Not Started");
        }
        ChannelEventRoute channelRoute = (ChannelEventRoute)this.eventsRoutes.get(event.getClass());
        if (channelRoute == null) {
            for (Class<?> c = event.getClass().getSuperclass(); c != null && channelRoute == null; c = c.getSuperclass()) {
                channelRoute = (ChannelEventRoute)this.eventsRoutes.get(c);
            }
            if (channelRoute != null) {
                this.eventsRoutes.put(event.getClass(), channelRoute);
            } else {
                throw new AppiaEventException(5, "Unwanted Event '" + event.getClass().getName() + "' on Channel '" + this.channelID + "'.");
            }
        }
        return channelRoute;
    }

    public int getFirstSession(ChannelEventRoute channelRoute, int dir, Session source) throws AppiaEventException {
        int i;
        Session[] route = channelRoute.getRoute();
        if (source == null) {
            if (dir == 1) {
                return 0;
            }
            return route.length - 1;
        }
        for (i = this.sessions.length - 1; i >= 0 && this.sessions[i] != source; --i) {
        }
        if (i < 0) {
            throw new AppiaEventException(4, "Session not memeber of Channel");
        }
        i += dir;
        int index = -1;
        while (i >= 0 && i < this.sessions.length && index < 0) {
            for (index = route.length - 1; index >= 0 && route[index] != this.sessions[i]; --index) {
            }
            i += dir;
        }
        return index < 0 ? route.length : index;
    }

    public QoS getQoS() {
        return this.qos;
    }

    public boolean equalQoS(Channel channel) {
        return this.qos.equals(channel.qos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws AppiaDuplicatedSessionsException {
        int i;
        Channel channel = this;
        synchronized (channel) {
            if (this.started || this.alive) {
                return;
            }
            this.started = true;
        }
        for (i = this.sessions.length - 1; i >= 0; --i) {
            if (this.sessions[i] == null) continue;
            this.sessions[i].boundSessions(this);
        }
        this.createUnboundedSessions();
        for (i = 0; i < this.sessions.length; ++i) {
            for (int j = i + 1; j < this.sessions.length; ++j) {
                if (this.sessions[i] != this.sessions[j]) continue;
                throw new AppiaDuplicatedSessionsException();
            }
        }
        this.makeEventsRoutes();
        try {
            if (Thread.currentThread() == this.eventScheduler.getAppiaInstance().instanceGetAppiaThread()) {
                new ChannelInit(this).go();
            } else {
                new ChannelInit().asyncGo(this, 1);
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        if (this.jmxConfiguration != null) {
            try {
                this.registerMBean();
            }
            catch (AppiaException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isStarted() {
        return this.started || this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        Channel channel = this;
        synchronized (channel) {
            if (this.jmxConfiguration != null) {
                try {
                    this.unregisterMBean();
                }
                catch (AppiaException e) {
                    e.printStackTrace();
                }
            }
            if (this.alive) {
                try {
                    if (Thread.currentThread() == this.eventScheduler.getAppiaInstance().instanceGetAppiaThread()) {
                        new ChannelClose(this).go();
                    } else {
                        new ChannelClose().asyncGo(this, -1);
                    }
                    this.alive = false;
                }
                catch (AppiaEventException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public ChannelCursor getCursor() {
        return new ChannelCursor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertEvent(Event event) throws AppiaEventException {
        Channel channel = this;
        synchronized (channel) {
            if (!this.alive && !(event instanceof ChannelInit)) {
                if (this.started) {
                    while (!this.alive) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    throw new AppiaEventException(6, "Channel is Closed");
                }
            }
        }
        this.eventScheduler.insert(event);
    }

    private void createUnboundedSessions() {
        Layer[] layers = this.qos.getLayers();
        for (int i = this.sessions.length - 1; i >= 0; --i) {
            if (this.sessions[i] != null) continue;
            this.sessions[i] = layers[i].createSession();
        }
    }

    private void makeEventsRoutes() {
        QoSEventRoute[] qosRoutes = this.qos.getEventsRoutes();
        this.eventsRoutes = new Hashtable();
        for (int i = 0; i < qosRoutes.length; ++i) {
            this.eventsRoutes.put(qosRoutes[i].getEventType(), qosRoutes[i].makeChannelRoute(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Event event) {
        if (event instanceof ChannelInit) {
            Channel channel = this;
            synchronized (channel) {
                this.alive = true;
                this.started = false;
                this.notifyAll();
            }
            return;
        }
        if (event instanceof ChannelClose) {
            this.eventsRoutes.clear();
            return;
        }
        if (event instanceof Timer) {
            this.timerManager.handleTimerRequest((Timer)event);
            return;
        }
        if (event instanceof PeriodicTimer) {
            this.timerManager.handlePeriodicTimer((PeriodicTimer)event);
            return;
        }
        if (event instanceof Debug) {
            return;
        }
        if (event instanceof EchoEvent) {
            Event e = ((EchoEvent)event).getEvent();
            e.setChannel(this);
            e.setDir(event.getDir() == 1 ? -1 : 1);
            e.setSourceSession(null);
            try {
                e.init();
                e.go();
            }
            catch (AppiaEventException ex) {
                System.err.println("appia.Channel.handle(Event): exception (\"" + ex.getMessage() + "\") while processing EchoEvent in \"" + this.channelID + "\" channel.");
            }
            return;
        }
    }

    private void registerMBean() throws AppiaException {
        log.info((Object)("Registering MBean for channel " + this.channelID));
        ChannelManager manager = new ChannelManager(this);
        Session currentSession = null;
        int numSensorSessions = 0;
        int numManagedSessions = 0;
        ChannelCursor cc = this.getCursor();
        cc.top();
        while (cc.isPositioned()) {
            currentSession = cc.getSession();
            if (currentSession instanceof SensorSession) {
                ((SensorSession)((Object)currentSession)).addSensorListener(manager);
                ++numSensorSessions;
            }
            if (currentSession instanceof ManagedSession) {
                manager.addManagedSession(currentSession);
                ++numManagedSessions;
            }
            cc.down();
        }
        if (this.jmxConfiguration.isLocal()) {
            String beanID = this.jmxConfiguration.getManagementMBeanID() + ":" + this.getChannelID();
            AppiaMBeanContainer.getInstance().registerBean(beanID, manager);
        } else {
            ManagementServerFactory.getInstance(this.jmxConfiguration).registerMBean(this, manager);
        }
        log.info((Object)("MBean registered on channel " + this.channelID + ". Listening on " + numSensorSessions + " SensorSession(s) and " + numManagedSessions + " ManagedSession(s)."));
    }

    private void unregisterMBean() throws AppiaException {
        log.info((Object)("Unregistering MBean for channel " + this.channelID));
        Session currentSession = null;
        ChannelManager manager = null;
        if (this.jmxConfiguration.isLocal()) {
            String beanID = this.jmxConfiguration.getManagementMBeanID() + ":" + this.getChannelID();
            AppiaMBeanContainer.getInstance().unregisterBean(beanID);
        } else {
            manager = (ChannelManager)ManagementServerFactory.getInstance(this.jmxConfiguration).unregisterMBean(this);
        }
        ChannelCursor cc = this.getCursor();
        cc.top();
        while (cc.isPositioned()) {
            currentSession = cc.getSession();
            if (currentSession instanceof SensorSession) {
                ((SensorSession)((Object)currentSession)).removeSensorListener(manager);
                manager.removeManagedSession(currentSession);
            }
            cc.down();
        }
        log.info((Object)("MBean unregistered from channel " + this.channelID + "."));
    }

    public JMXConfiguration getJMXConfiguration() {
        return this.jmxConfiguration;
    }
}

