/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import net.sf.appia.core.AppiaCursorException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;

public class ChannelCursor {
    private static final int NOTSET = -2;
    Session[] sessions;
    Layer[] layers;
    Channel channel;
    int pos = -2;

    public ChannelCursor(Channel channel) {
        this.channel = channel;
        this.sessions = channel.sessions;
        this.layers = channel.getQoS().layers;
    }

    public void down() throws AppiaCursorException {
        if (this.pos == -2) {
            throw new AppiaCursorException(1);
        }
        if (this.pos < 0) {
            throw new AppiaCursorException(2);
        }
        --this.pos;
    }

    public void up() throws AppiaCursorException {
        if (this.pos == -2) {
            throw new AppiaCursorException(1);
        }
        if (this.pos >= this.sessions.length) {
            throw new AppiaCursorException(3);
        }
        ++this.pos;
    }

    public void top() {
        this.pos = this.sessions.length - 1;
    }

    public void bottom() {
        this.pos = 0;
    }

    public boolean isPositioned() {
        return this.pos >= 0 && this.pos < this.sessions.length;
    }

    public void setSession(Session session) throws AppiaCursorException {
        if (this.pos == -2) {
            throw new AppiaCursorException(1);
        }
        if (this.sessions[this.pos] != null) {
            throw new AppiaCursorException(4, "Session has already been Set");
        }
        if (this.layers[this.pos].getClass() != session.getLayer().getClass()) {
            throw new AppiaCursorException(5, "Wrong Session Layer");
        }
        this.sessions[this.pos] = session;
    }

    public Session getSession() throws AppiaCursorException {
        if (this.pos == -2) {
            throw new AppiaCursorException(1);
        }
        if (this.pos < 0) {
            throw new AppiaCursorException(2);
        }
        if (this.pos >= this.sessions.length) {
            throw new AppiaCursorException(3);
        }
        return this.sessions[this.pos];
    }

    public Layer getLayer() throws AppiaCursorException {
        if (this.pos < 0) {
            throw new AppiaCursorException(1);
        }
        return this.layers[this.pos];
    }

    public void jump(int offset) throws AppiaCursorException {
        if (this.pos == -2) {
            throw new AppiaCursorException(1);
        }
        if ((offset += this.pos) < 0 || offset >= this.sessions.length) {
            throw new AppiaCursorException(6);
        }
        this.pos = offset;
    }

    public void jumpTo(int position) throws AppiaCursorException {
        if (this.pos == -2) {
            throw new AppiaCursorException(1);
        }
        if (position < 0 || position >= this.sessions.length) {
            throw new AppiaCursorException(6);
        }
        this.pos = position;
    }
}

