/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import java.io.PrintStream;
import java.security.InvalidParameterException;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.ChannelEventRoute;
import net.sf.appia.core.EventScheduler;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelEvent;
import net.sf.appia.core.memoryManager.MemoryManager;

public class Event {
    protected static final int MAX_PRIORITY = 255;
    protected static final int DEFAULT_PRIORITY = 127;
    protected static final int MIN_PRIORITY = 0;
    private int currentSession = -1;
    private int firstSession = -1;
    private Channel channel = null;
    private EventScheduler eventScheduler = null;
    private Session src;
    private int dir = 0;
    private Session[] route = null;
    private boolean isInitiated = false;
    private boolean sourceSet = false;
    private Thread appiaThread = null;
    private int priority = 127;
    private Object schedulerData = null;

    public Event() {
    }

    public Event(Channel channel, int dir, Session src) throws AppiaEventException {
        this.channel = channel;
        this.dir = dir;
        this.src = src;
        this.sourceSet = true;
        this.init();
    }

    public void setDir(int dir) {
        this.dir = dir;
        this.isInitiated = false;
    }

    public int getDir() {
        return this.dir;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this.isInitiated = false;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setSourceSession(Session src) {
        this.src = src;
        this.sourceSet = true;
        this.isInitiated = false;
    }

    public Session getSourceSession() {
        return this.src;
    }

    @Deprecated
    public void setSource(Session src) {
        this.setSourceSession(src);
    }

    @Deprecated
    public Session getSource() {
        return this.getSourceSession();
    }

    public final boolean isAccepted() {
        return true;
    }

    public final Session popSession() {
        if (this.currentSession < 0) {
            this.currentSession = this.firstSession;
        } else if (this.currentSession == 0 && this.dir == -1) {
            this.currentSession = this.route.length;
        } else if (this.currentSession < this.route.length) {
            this.currentSession += this.dir;
        } else if (this.currentSession == this.route.length) {
            this.currentSession = Integer.MAX_VALUE;
        }
        if (this.currentSession >= 0 && this.currentSession < this.route.length) {
            return this.route[this.currentSession];
        }
        if (this.currentSession == this.route.length && this instanceof ChannelEvent) {
            this.channel.handle(this);
        }
        if (this.currentSession == this.route.length && this instanceof SendableEvent) {
            ((SendableEvent)this).detachFromMemory();
        }
        return null;
    }

    public final Session currentSession() {
        if (this.currentSession >= 0 && this.currentSession < this.route.length) {
            return this.route[this.currentSession];
        }
        return null;
    }

    public final void go() throws AppiaEventException {
        if (!this.isInitiated) {
            throw new AppiaEventException(1, "Event not initialized");
        }
        if (this.appiaThread == null) {
            this.appiaThread = this.eventScheduler.getAppiaInstance().instanceGetAppiaThread();
        }
        if (Thread.currentThread() != this.appiaThread) {
            throw new AppiaEventException(8, "Method \"go\" called from outside the Appia thread");
        }
        this.eventScheduler.insert(this);
    }

    public final void init() throws AppiaEventException {
        if (this.channel == null) {
            throw new AppiaEventException(2, "Missing Event attribute: Channel");
        }
        if (this.dir != 1 && this.dir != -1) {
            throw new AppiaEventException(2, "Missing, or Incorrect, Event attribute: Direction");
        }
        if (!this.sourceSet) {
            throw new AppiaEventException(2, "Missing Event attribute: Source");
        }
        ChannelEventRoute channelRoute = this.channel.getEventRoute(this);
        this.route = channelRoute.getRoute();
        this.firstSession = this.channel.getFirstSession(channelRoute, this.dir, this.src);
        this.currentSession = -1;
        this.eventScheduler = this.channel.getEventScheduler();
        this.appiaThread = this.eventScheduler.getAppiaInstance().instanceGetAppiaThread();
        this.isInitiated = true;
    }

    public void debug(PrintStream out) {
        out.println("Event:");
        out.println(this);
    }

    public Event cloneEvent() throws CloneNotSupportedException {
        Event e = (Event)this.clone();
        e.isInitiated = false;
        e.src = null;
        e.sourceSet = false;
        return e;
    }

    public final void asyncGo(Channel channel, int dir) throws AppiaEventException {
        this.channel = channel;
        this.dir = dir;
        this.src = null;
        this.sourceSet = true;
        this.init();
        if (Thread.currentThread() == this.appiaThread) {
            throw new AppiaEventException(8, "Method \"asyncGo\" called from within Appia thread");
        }
        MemoryManager mm = channel.getMemoryManager();
        if (mm != null) {
            try {
                mm.synchronizedAboveThreshold(this.dir);
            }
            catch (InterruptedException e) {
                throw new AppiaEventException("Unable to insert event asynchronously", e);
            }
        }
        channel.insertEvent(this);
    }

    protected void setSchedulerData(Object schedulerData) {
        this.schedulerData = schedulerData;
    }

    protected Object getSchedulerData() {
        return this.schedulerData;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) throws InvalidParameterException {
        if (priority < 0 || priority > 255) {
            throw new InvalidParameterException("Priority of event must be defined between 0 and 255");
        }
        this.priority = priority;
    }
}

