/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.sf.appia.core.Channel;
import net.sf.appia.management.AppiaManagementException;
import net.sf.appia.management.jmx.JMXConfiguration;
import org.apache.log4j.Logger;

public class ManagementServerFactory {
    private static Logger log = Logger.getLogger(ManagementServerFactory.class);
    private static Hashtable<JMXConfiguration, ManagementServerFactory> factories = new Hashtable();
    private MBeanServer mbeanServer = null;
    private Hashtable<Channel, Object> managedChannels = new Hashtable();

    private ManagementServerFactory() throws AppiaManagementException {
        this.createMBeanServer();
    }

    public static ManagementServerFactory getInstance(JMXConfiguration config) throws AppiaManagementException {
        ManagementServerFactory factory = factories.get(config);
        if (factory == null) {
            factory = new ManagementServerFactory();
            factories.put(config, factory);
        }
        return factory;
    }

    private void createMBeanServer() throws AppiaManagementException {
        if (this.mbeanServer != null) {
            return;
        }
        log.info((Object)"Creating MBean server for this process.");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public void registerMBean(Channel channel, Object mbean) throws AppiaManagementException {
        try {
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(mbean, new ObjectName(Channel.class.getName() + ":name=" + channel.getChannelID()));
            }
            this.managedChannels.put(channel, mbean);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new AppiaManagementException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new AppiaManagementException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new AppiaManagementException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new AppiaManagementException(e);
        }
    }

    public Object unregisterMBean(Channel channel) throws AppiaManagementException {
        try {
            if (this.mbeanServer != null) {
                this.mbeanServer.unregisterMBean(new ObjectName(Channel.class.getName() + ":name=" + channel.getChannelID()));
            }
            return this.managedChannels.remove(channel);
        }
        catch (InstanceNotFoundException e) {
            throw new AppiaManagementException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new AppiaManagementException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new AppiaManagementException(e);
        }
    }
}

